package foundry.veil.api.client.editor;

import foundry.veil.api.client.render.VeilRenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.lwjgl.system.NativeResource;

/**
 * A basic panel that can be toggled in the editor view.
 *
 * @author Ocelot
 */
public interface Inspector extends NativeResource {

    class_2561 DEFAULT_GROUP = class_2561.method_43471("inspector_group.veil.default");
    class_2561 EXAMPLE_GROUP = class_2561.method_43471("inspector_group.veil.example");
    class_2561 RENDERER_GROUP = class_2561.method_43471("inspector_group.veil.renderer");
    class_2561 INFO_GROUP = class_2561.method_43471("inspector_group.veil.info");
    class_2561 RESOURCE_GROUP = class_2561.method_43471("inspector_group.veil.resource");

    /**
     * Renders elements into the menu bar. Only called if {@link #isMenuBarEnabled()} is <code>true</code>.
     */
    default void renderMenuBar() {
    }

    /**
     * Renders this editor to the screen.
     */
    void render();

    /**
     * Called just before the imgui state is drawn to the screen
     */
    default void renderLast() {
    }

    /**
     * @return The visible display name of this editor
     */
    class_2561 getDisplayName();

    /**
     * @return The name of the tab group to put this editor in
     */
    default class_2561 getGroup() {
        return DEFAULT_GROUP;
    }

    /**
     * @return Whether this editor should be selectable.
     */
    default boolean isEnabled() {
        return true;
    }

    /**
     * @return Whether this editor should draw into the menu bar
     */
    default boolean isMenuBarEnabled() {
        return false;
    }

    /**
     * Called when this editor is first opened.
     */
    default void onShow() {
    }

    /**
     * Called when this editor is no longer open.
     */
    default void onHide() {
    }

    /**
     * @return Whether this editor is open
     */
    default boolean isOpen() {
        return VeilRenderSystem.renderer().getEditorManager().isVisible(this);
    }

    /**
     * Frees any resources allocated by this editor before being destroyed.
     */
    @Override
    default void free() {
    }

    static class_2561 group(class_2960 id) {
        return class_2561.method_43471("editor_group." + id.method_12836() + "." + id.method_12832());
    }
}
