package foundry.veil.api.client.property.properties;

import foundry.veil.api.client.property.InvertibleProperty;
import foundry.veil.api.client.registry.PropertyRegistry;
import foundry.veil.api.flare.modifier.PropertyModifier;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_284;
import net.minecraft.class_5944;

public class Mat3Property extends InvertibleProperty<Matrix3f> {

    public Mat3Property(Matrix3fc value) {
        super(PropertyRegistry.MAT3.get(), new Matrix3f(value));
    }

    @Override
    public void applyValue(String name, class_5944 shader) {
        class_284 uniform = shader.method_34582(name);
        if (uniform != null) {
            uniform.method_39978(this.overrideValue);
        }
    }

    @Override
    protected void setQueries(MolangRuntime.Builder builder) {
        super.setQueries(builder);
    }

    @Override
    public void modifyPreInvert(Matrix3f value, PropertyModifier.PropertyModifierMode mode, Optional<List<MolangExpression>> optionalMolang) {
        switch (mode) {
            case ADD -> this.overrideValue.add(value);
            case SUBTRACT -> this.overrideValue.sub(value);
            case MULTIPLY -> this.overrideValue.mul(value);
            case REPLACE, MOLANG -> this.overrideValue.set(value);
        }
    }

    @Override
    protected Matrix3f cloneValue(Matrix3f value) {
        return new Matrix3f(value);
    }

    @Override
    protected Matrix3f calculateInverse(Matrix3f value) {
        return value.invert();
    }
}
