package foundry.veil.api.client.property.properties;

import foundry.veil.api.client.property.ImmutableProperty;
import foundry.veil.api.client.property.Property;
import foundry.veil.api.client.registry.PropertyRegistry;
import foundry.veil.api.flare.data.effect.FlareMaterial;
import foundry.veil.api.flare.modifier.PropertyModifier;
import gg.moonflower.molangcompiler.api.MolangExpression;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_284;
import net.minecraft.class_5819;
import net.minecraft.class_5944;

/**
 * <p>A property that applies a random value each time.</p>
 * Added as a default property named <code>_Seed</code> in all {@link FlareMaterial} that have {@link FlareMaterial#randomizeSeed()} set to <code>true</code>.
 *
 * @author GuyApooye
 */
@ImmutableProperty
public class RandomFloatProperty extends Property<Float> {

    private final class_5819 randomSource = class_5819.method_43049(10841L);
    public static final RandomFloatProperty INSTANCE = new RandomFloatProperty();

    private RandomFloatProperty() {
        super(PropertyRegistry.FLOAT.get(), 0.0f);
    }

    @Override
    public void applyValue(String name, class_5944 shader) {
        class_284 uniform = shader.method_34582(name);
        if (uniform != null) {
            uniform.method_1251(this.randomSource.method_43057());
        }
    }

    @Override
    public void modify(Float value, PropertyModifier.PropertyModifierMode mode, Optional<List<MolangExpression>> optionalMolang) {
    }

    @Override
    protected Float cloneValue(Float value) {
        return value;
    }
}
