package foundry.veil.api.client.render.shader;

import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_7654;

import static org.lwjgl.opengl.GL20C.GL_FRAGMENT_SHADER;
import static org.lwjgl.opengl.GL20C.GL_VERTEX_SHADER;
import static org.lwjgl.opengl.GL32C.GL_GEOMETRY_SHADER;
import static org.lwjgl.opengl.GL40C.GL_TESS_CONTROL_SHADER;
import static org.lwjgl.opengl.GL40C.GL_TESS_EVALUATION_SHADER;
import static org.lwjgl.opengl.GL43C.GL_COMPUTE_SHADER;

/**
 * A location to load shader source files from.
 *
 * @author Ocelot
 */
public final class ShaderSourceSet {

    private static final Map<String, Integer> EXTENSION_TYPES = Map.of(
            ".vsh", GL_VERTEX_SHADER,
            ".tcsh", GL_TESS_CONTROL_SHADER,
            ".tesh", GL_TESS_EVALUATION_SHADER,
            ".gsh", GL_GEOMETRY_SHADER,
            ".fsh", GL_FRAGMENT_SHADER,
            ".comp", GL_COMPUTE_SHADER
    );

    private final String folder;
    private final class_7654 shaderDefinitionLister;
    private final class_7654 glslConverter;
    private final Map<Integer, class_7654> typeConverters;

    public ShaderSourceSet(String folder) {
        this.folder = folder;
        this.shaderDefinitionLister = class_7654.method_45114(folder);
        this.glslConverter = new class_7654(folder, ".glsl");
        this.typeConverters = Map.of(
                GL_VERTEX_SHADER, new class_7654(folder, ".vsh"),
                GL_TESS_CONTROL_SHADER, new class_7654(folder, ".tcsh"),
                GL_TESS_EVALUATION_SHADER, new class_7654(folder, ".tesh"),
                GL_GEOMETRY_SHADER, new class_7654(folder, ".gsh"),
                GL_FRAGMENT_SHADER, new class_7654(folder, ".fsh"),
                GL_COMPUTE_SHADER, new class_7654(folder, ".comp")
        );
    }

    /**
     * @return The location to load shader definitions from
     */
    public String getFolder() {
        return this.folder;
    }

    /**
     * @return The lister for shader definitions
     */
    public class_7654 getShaderDefinitionLister() {
        return this.shaderDefinitionLister;
    }

    /**
     * @return The converter for a regular <code>glsl</code> shader type
     */
    public class_7654 getGlslConverter() {
        return this.glslConverter;
    }

    /**
     * Retrieves the id converter of a shader type.
     *
     * @param type The GL enum for the type
     * @return The file type converter or <code>glsl</code> if the type is unknown
     */
    public class_7654 getTypeConverter(int type) {
        return this.typeConverters.getOrDefault(type, this.glslConverter);
    }

    /**
     * Retrieves the type of shader the location points to based on extension.
     *
     * @param location The location of the file
     * @return The GL type of the shader or <code>-1</code> if invalid
     */
    public static int getShaderType(class_2960 location) {
        for (Map.Entry<String, Integer> entry : EXTENSION_TYPES.entrySet()) {
            if (location.method_12832().endsWith(entry.getKey())) {
                return entry.getValue();
            }
        }
        return -1;
    }
}
