package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.mixin.pipeline.accessor.PipelineNativeImageAccessor;
import net.minecraft.class_1011;
import net.minecraft.class_1044;

import static org.lwjgl.opengl.ARBDirectStateAccess.glTextureParameteri;
import static org.lwjgl.opengl.GL11C.*;
import static org.lwjgl.opengl.GL12C.*;
import static org.lwjgl.opengl.GL14C.GL_TEXTURE_LOD_BIAS;
import static org.lwjgl.opengl.GL30C.GL_TEXTURE_2D_ARRAY;

public abstract class ArrayTexture extends class_1044 {

    private int width;
    private int height;

    protected void init(int format, int mipmapLevel, int width, int height, int depth) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.method_23207();
        if (mipmapLevel >= 0) {
            GlStateManager._texParameter(GL_TEXTURE_2D_ARRAY, GL_TEXTURE_MAX_LEVEL, mipmapLevel);
            GlStateManager._texParameter(GL_TEXTURE_2D_ARRAY, GL_TEXTURE_MIN_LOD, 0);
            GlStateManager._texParameter(GL_TEXTURE_2D_ARRAY, GL_TEXTURE_MAX_LOD, mipmapLevel);
            GlStateManager._texParameter(GL_TEXTURE_2D_ARRAY, GL_TEXTURE_LOD_BIAS, 0.0F);
        }

        this.width = width;
        this.height = height;
        for (int i = 0; i <= mipmapLevel; i++) {
            glTexImage3D(GL_TEXTURE_2D_ARRAY, i, format, width >> i, height >> i, depth, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0L);
        }
    }

    protected void upload(class_1011... images) {
        this.method_23207();
        for (int i = 0; i < images.length; i++) {
            class_1011 image = images[i];
            if (image.method_4307() != this.width || image.method_4323() != this.height) {
                throw new IllegalArgumentException("Image dimensions don't match");
            }
            glTexSubImage3D(GL_TEXTURE_2D_ARRAY, 0, 0, 0, i, image.method_4307(), image.method_4323(), 1, image.method_4318().method_4333(), GL_UNSIGNED_BYTE, ((PipelineNativeImageAccessor) (Object) image).getPixels());
        }
    }

    @Override
    public void method_4527(boolean blur, boolean mipmap) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.field_5205 = blur;
        this.field_5203 = mipmap;
        int minFilter;
        int magFilter;
        if (blur) {
            minFilter = mipmap ? GL_LINEAR_MIPMAP_LINEAR : GL_LINEAR;
            magFilter = GL_LINEAR;
        } else {
            minFilter = mipmap ? GL_NEAREST_MIPMAP_LINEAR : GL_NEAREST;
            magFilter = GL_NEAREST;
        }

        if (VeilRenderSystem.directStateAccessSupported()) {
            int id = this.method_4624();
            glTextureParameteri(id, GL_TEXTURE_MIN_FILTER, minFilter);
            glTextureParameteri(id, GL_TEXTURE_MAG_FILTER, magFilter);
        } else {
            this.method_23207();
            glTexParameteri(GL_TEXTURE_2D_ARRAY, GL_TEXTURE_MIN_FILTER, minFilter);
            glTexParameteri(GL_TEXTURE_2D_ARRAY, GL_TEXTURE_MAG_FILTER, magFilter);
        }
    }

    @Override
    public int method_4624() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.field_5204 == -1) {
            this.field_5204 = VeilRenderSystem.createTextures(GL_TEXTURE_2D_ARRAY);
        }

        return this.field_5204;
    }

    @Override
    public void method_23207() {
        glBindTexture(GL_TEXTURE_2D_ARRAY, this.method_4624());
    }
}
