package foundry.veil.api.client.render.texture;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_3270;
import net.minecraft.class_3518;

public record TextureTypeMetadataSection(TextureType type) {

    public static final Serializer SERIALIZER = new Serializer();

    public enum TextureType {
        TEXTURE_2D,
        TEXTURE_2D_ARRAY,
        TEXTURE_CUBE_MAP;

        private static final TextureType[] VALUES = TextureType.values();
    }

    public static class Serializer implements class_3270<TextureTypeMetadataSection> {

        @Override
        public TextureTypeMetadataSection method_14421(@NotNull JsonObject json) {
            String type = class_3518.method_15253(json, "type", "2d");
            for (TextureType value : TextureType.VALUES) {
                if (value.name().substring(8).equalsIgnoreCase(type)) {
                    return new TextureTypeMetadataSection(value);
                }
            }
            throw new JsonSyntaxException("Unknown texture type: " + type + ". Expected one of " + Arrays.stream(TextureType.VALUES)
                    .map(textureType -> textureType.name().toLowerCase(Locale.ROOT))
                    .collect(Collectors.joining(", ")));
        }

        @Override
        public @NotNull String method_14420() {
            return "veil:texture_type";
        }
    }
}
