package foundry.veil.api.client.render.vertex;

import java.util.Arrays;
import net.minecraft.class_293;
import net.minecraft.class_296;

import static net.minecraft.class_296.*;

public class VeilVertexFormat {

    public static final class_296 BONE_INDEX = register(0, class_296.class_297.field_1622, class_296.class_298.field_20782, 1);

    // todo: padding???
    public static final class_293 SKINNED_MESH = class_293.method_60833()
            .method_60842("Position", field_52107)
            .method_60842("Color", field_52108)
            .method_60842("UV0", field_52109) // texture coordinates
            .method_60842("UV1", field_52111) // lightmap coordinates
            .method_60842("UV2", field_52112) // overlay coordinates
            .method_60842("Normal", field_52113)
            .method_60842("BoneIndex", BONE_INDEX)
            .method_60840();
    public static final class_293 QUASAR_PARTICLE = class_293.method_60833()
            .method_60842("Position", field_52107)
            .method_60842("UV0", field_52109)
            .method_60842("Color", field_52108)
            .method_60842("UV2", field_52112)
            .method_60842("Normal", field_52113)
            .method_60840();

    /**
     * Registers a new vertex format element by assigning it to the next open ID, expanding the array if necessary.
     *
     * @param index The index of the element
     * @param type  The type of data to store
     * @param usage The way the element is used
     * @param count The number of components
     * @return A new element
     */
    public static class_296 register(int index, class_296.class_297 type, class_296.class_298 usage, int count) {
        for (int i = 0; i < class_296.field_52114.length; i++) {
            if (class_296.field_52114[i] == null) {
                return class_296.method_60845(i, index, type, usage, count);
            }
        }

        class_296.field_52114 = Arrays.copyOf(class_296.field_52114, class_296.field_52114.length + 1);
        return class_296.method_60845(class_296.field_52114.length - 2, index, type, usage, count);
    }
}
