package foundry.veil.api.flare.data.model;

import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.flare.model.BakedShell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;

/**
 * @since 2.5.0
 */
public class SimpleBakedShell implements BakedShell {

    protected final List<FlareBakedQuad> faces;
    private VertexArray vertexArray;

    public SimpleBakedShell(List<FlareBakedQuad> faces) {
        this.faces = Collections.unmodifiableList(faces);
    }

    @Override
    public List<FlareBakedQuad> getQuads() {
        return this.faces;
    }

    @Override
    public VertexArray getVertexArray() {
        if (this.vertexArray == null) {
            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1590);

            for (FlareBakedQuad quad : this.faces) {
                quad.putBakedQuadInto(builder);
            }

            this.vertexArray = VertexArray.create();
            this.vertexArray.upload(builder.method_60800(), VertexArray.DrawUsage.STATIC);
        }
        return this.vertexArray;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void free() {
        if (this.vertexArray != null) {
            this.vertexArray.free();
            this.vertexArray = null;
        }
    }

    public static class Builder {

        protected final List<FlareBakedQuad> faces = new ArrayList<>();

        public Builder addFace(FlareBakedQuad face) {
            this.faces.add(face);
            return this;
        }

        public SimpleBakedShell build() {
            return new SimpleBakedShell(this.faces);
        }
    }
}
