package foundry.veil.api.flare.model;

import foundry.veil.Veil;
import foundry.veil.api.flare.data.model.*;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_753;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Bakes {@link UnbakedShell} into {@link BakedShell}.
 *
 * @since 2.5.0
 */
public final class ShellBakery {

    public static final class_2960 MISSING_SHELL_LOCATION = Veil.veilPath("builtin/missing");
    public static final BakedShell MISSING_SHELL;

    static {
        Map<class_2350, ShellElementFace> faces = new EnumMap<>(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            faces.put(direction, new ShellElementFace(new ShellFaceUV(0, 0, 16, 16, 0)));
        }
        UnbakedShell unbaked = new FlareShell(List.of(new ShellElement(
                new Vector3f(0, 0, 0),
                new Vector3f(16, 16, 16),
                null,
                faces
        )));

        MISSING_SHELL = Objects.requireNonNull(unbaked.bake(), "Missing Shell");
    }

    private ShellBakery() {
    }

    public static FlareBakedQuad bakeQuad(ShellElement element, ShellElementFace face, class_2350 direction) {
        return bakeQuad(element.from(), element.to(), face, direction, element.rotation());
    }

    public static FlareBakedQuad bakeQuad(
            Vector3fc from,
            Vector3fc to,
            ShellElementFace face,
            class_2350 facing,
            ShellElementRotation rotation) {
        Vector3f normal = facing.method_23955();
        float[] vertexData = makeVertices(face.uv(), normal, facing, setupShape(from, to), rotation);
        return new FlareBakedQuad(vertexData, normal);
    }

    private static float[] makeVertices(ShellFaceUV uvs, Vector3f normal, class_2350 direction, float[] posDiv16, @Nullable ShellElementRotation rotation) {
        float[] vertexData = new float[20];
        Matrix4f rotationMatrix = null;
        if (rotation != null) {
            float angle = rotation.angle() * class_3532.field_29847;
            rotationMatrix = switch (rotation.axis()) {
                case field_11048 -> new Matrix4f().rotationX(angle);
                case field_11052 -> new Matrix4f().rotationY(angle);
                case field_11051 -> new Matrix4f().rotationZ(angle);
            };
            rotationMatrix.transformDirection(normal);
        }
        for (int i = 0; i < 4; i++) {
            bakeVertex(vertexData, i, direction, uvs, posDiv16, rotation, rotationMatrix);
        }

        return vertexData;
    }

    private static void bakeVertex(float[] vertexData, int vertexIndex, class_2350 direction, ShellFaceUV shellFaceUV, float[] posDiv16, @Nullable ShellElementRotation rotation, @Nullable Matrix4f transform) {
        class_753.class_755 vertexInfo = class_753.method_3163(direction).method_3162(vertexIndex);
        Vector3f pos = new Vector3f(posDiv16[vertexInfo.field_3975], posDiv16[vertexInfo.field_3974], posDiv16[vertexInfo.field_3973]);
        if (rotation != null && transform != null) {
            Vector3f origin = new Vector3f(rotation.origin()).div(16.0F).sub(0.5f, 0.0f, 0.5f);

            Vector3f offset = transform.transformPosition(new Vector3f(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z()));
            pos.set(offset.x() + origin.x(), offset.y() + origin.y(), offset.z() + origin.z());
        }
        fillVertex(vertexData, vertexIndex, pos, shellFaceUV);
    }

    private static float[] setupShape(Vector3fc min, Vector3fc max) {
        float[] vertexPosition = new float[class_2350.values().length];
        //center the center
        vertexPosition[class_753.class_754.field_3967] = min.x() / 16.0F - 0.5f;
        vertexPosition[class_753.class_754.field_3968] = min.y() / 16.0F;
        vertexPosition[class_753.class_754.field_3969] = min.z() / 16.0F - 0.5f;
        vertexPosition[class_753.class_754.field_3970] = max.x() / 16.0F - 0.5f;
        vertexPosition[class_753.class_754.field_3971] = max.y() / 16.0F;
        vertexPosition[class_753.class_754.field_3972] = max.z() / 16.0F - 0.5f;
        return vertexPosition;
    }

    private static void fillVertex(float[] vertexData, int vertexIndex, Vector3f pos, ShellFaceUV shellFaceUV) {
        int i = vertexIndex * 5;
        vertexData[i] = pos.x();
        vertexData[i + 1] = pos.y();
        vertexData[i + 2] = pos.z();
        vertexData[i + 3] = shellFaceUV.getU(vertexIndex) / 16.0F;
        vertexData[i + 4] = shellFaceUV.getV(vertexIndex) / 16.0F;
    }
}
