package foundry.veil.api.quasar.data;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.resource.VeilDynamicRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7655;

public final class QuasarParticles {

    public static final class_5321<class_2378<ParticleModuleData>> INIT_MODULES = createRegistryKey("quasar/modules/init");
    public static final class_5321<class_2378<ParticleModuleData>> UPDATE_MODULES = createRegistryKey("quasar/modules/update");
    public static final class_5321<class_2378<ParticleModuleData>> RENDER_MODULES = createRegistryKey("quasar/modules/render");
    public static final class_5321<class_2378<QuasarParticleData>> PARTICLE_DATA = createRegistryKey("quasar/modules/particle_data");
    public static final class_5321<class_2378<ParticleSettings>> PARTICLE_SETTINGS = createRegistryKey("quasar/modules/emitter/particle");
    public static final class_5321<class_2378<EmitterShapeSettings>> EMITTER_SHAPE_SETTINGS = createRegistryKey("quasar/modules/emitter/shape");
    public static final class_5321<class_2378<ParticleEmitterData>> EMITTER = createRegistryKey("quasar/emitters");

    private static final SuggestionProvider<?> EMITTER_SUGGESTION_PROVIDER = (unused, builder) -> registryAccess().method_33310(EMITTER).map(registry -> class_2172.method_9270(registry.method_10235(), builder)).orElseGet(Suggestions::empty);
    private static final List<class_7655.class_7657<?>> REGISTRIES = List.of(
            new class_7655.class_7657<>(INIT_MODULES, ParticleModuleData.INIT_DIRECT_CODEC, false),
            new class_7655.class_7657<>(UPDATE_MODULES, ParticleModuleData.UPDATE_DIRECT_CODEC, false),
            new class_7655.class_7657<>(RENDER_MODULES, ParticleModuleData.RENDER_DIRECT_CODEC, false),
            new class_7655.class_7657<>(PARTICLE_DATA, QuasarParticleData.DIRECT_CODEC, false),
            new class_7655.class_7657<>(PARTICLE_SETTINGS, ParticleSettings.DIRECT_CODEC, false),
            new class_7655.class_7657<>(EMITTER_SHAPE_SETTINGS, EmitterShapeSettings.DIRECT_CODEC, false),
            new class_7655.class_7657<>(EMITTER, ParticleEmitterData.DIRECT_CODEC, false)
    );
    private static class_5455 registryAccess = class_5455.field_40585;

    private QuasarParticles() {
    }

    @ApiStatus.Internal
    public static void bootstrap() {
        // This is here to make sure the class is loaded before particles are reloaded, otherwise KubeJS crashes
    }

    private static <T> class_5321<class_2378<T>> createRegistryKey(String name) {
        return class_5321.method_29180(Veil.veilPath(name));
    }

    @SuppressWarnings("unchecked")
    public static <T extends class_2172> SuggestionProvider<T> emitterSuggestionProvider() {
        return (SuggestionProvider<T>) EMITTER_SUGGESTION_PROVIDER;
    }

    public static class_5455 registryAccess() {
        return registryAccess;
    }

    @ApiStatus.Internal
    public static class Reloader implements class_3302 {

        @Override
        public @NotNull CompletableFuture<Void> method_25931(class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 preparationsProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
            return VeilDynamicRegistry.loadRegistries(resourceManager, REGISTRIES, backgroundExecutor)
                    .thenCompose(preparationBarrier::method_18352)
                    .thenAcceptAsync(data -> {
                        registryAccess = data.registryAccess();
                        ParticleEmitter.clearErrors();

                        String msg = VeilDynamicRegistry.printErrors(data.errors());
                        if (msg != null) {
                            Veil.LOGGER.error("Quasar registry loading errors:{}", msg);
                        }

                        Veil.LOGGER.info("Loaded {} quasar particles", registryAccess.method_30530(EMITTER).method_10204());
                        VeilRenderSystem.renderer().getParticleManager().clear();
                    }, gameExecutor);
        }

        @Override
        public @NotNull String method_22322() {
            return QuasarParticles.class.getSimpleName();
        }
    }
}
