package foundry.veil.api.quasar.emitters.module.update;

import foundry.veil.api.util.FastNoiseLite;
import net.minecraft.class_243;

/**
 * A global wind field. Applies a uniform velocity change to particles.
 * Ticking is also possible, allowing the wind to shift and change over time.
 */
public class WindField {
    class_243 windDirection;
    float strength;
    float falloff;
    FastNoiseLite noise;

    public WindField(class_243 windDirection, float strength, float falloff, FastNoiseLite noise) {
        this.windDirection = windDirection;
        this.strength = strength;
        this.falloff = falloff;
        this.noise = noise;
    }

    public class_243 getWindDirection() {
        return windDirection;
    }

    public void tickWind() {
        float x = (float) (windDirection.method_10216() + noise.GetNoise(0, 0, 0) * 0.01);
        float y = (float) (windDirection.method_10214() + noise.GetNoise(0, 0, 1) * 0.01);
        float z = (float) (windDirection.method_10215() + noise.GetNoise(0, 0, 2) * 0.01);
        windDirection = new class_243(x, y, z);
    }
}
