package foundry.veil.api.resource;

import java.util.OptionalInt;
import net.minecraft.class_2561;

/**
 * Adds an action to the context menu for performing actions on resources.
 *
 * @param <T> The type of resource to perform actions on
 * @author Ocelot, RyanH
 * @since 1.0.0
 */
public interface VeilResourceAction<T extends VeilResource<?>> {

    /**
     * @return The name of the action
     */
    class_2561 getName();

    /**
     * @return A brief description of the action
     */
    class_2561 getDescription();

    /**
     * @return The icon to display for the action
     */
    OptionalInt getIcon();

    /**
     * Performs the action on the specified resource
     */
    void perform(VeilEditorEnvironment environment, T resource);

}
