package foundry.veil.api.resource.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.BlockModelResource;
import imgui.ImGui;
import imgui.flag.ImGuiCond;
import imgui.flag.ImGuiWindowFlags;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1088;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import net.minecraft.client.renderer.block.model.*;
import org.jetbrains.annotations.ApiStatus;
import org.joml.*;

import java.io.Reader;
import java.lang.Math;
import java.util.List;

/**
 * Viewer for block models
 *
 * @author ryanhcode
 */
@ApiStatus.Internal
public class BlockModelInspector implements ResourceFileEditor<BlockModelResource> {

    private static final class_2561 TITLE = class_2561.method_43471("inspector.veil.block_model.title");
    private static final class_796 FACE_BAKERY = new class_796();
    private static final class_4587.class_4665 POSE = new class_4587().method_23760();

    private final ImBoolean open;
    private final VeilResourceManager resourceManager;
    private final BlockModelResource resource;

    private ObjectArrayList<class_777> quads;

    public BlockModelInspector(VeilEditorEnvironment environment, BlockModelResource resource) {
        this.open = new ImBoolean(true);
        this.resourceManager = environment.getResourceManager();
        this.resource = resource;
        this.loadFromDisk();
    }

    @Override
    public void render() {
        if (this.resource == null || !this.open.get()) {
            return;
        }

        VeilResourceInfo resourceInfo = this.resource.resourceInfo();

        ImGui.setNextWindowSizeConstraints(256.0F, 256.0F, Float.MAX_VALUE, Float.MAX_VALUE);
        ImGui.setNextWindowSize(256.0F, 256.0F, ImGuiCond.Once);
        if (ImGui.begin(TITLE.getString() + "###model_editor_" + resourceInfo.fileName(), this.open, ImGuiWindowFlags.NoScrollbar | ImGuiWindowFlags.NoSavedSettings)) {
            VeilImGuiUtil.resourceLocation(resourceInfo.location());
            int desiredWidth = ((int) ImGui.getContentRegionAvailX() - 2) * 2;
            int desiredHeight = ((int) ImGui.getContentRegionAvailY() - 2) * 2;

            if (desiredWidth <= 0 || desiredHeight <= 0) {
                ImGui.end();
                return;
            }

            int texture = VeilImGuiUtil.renderArea(desiredWidth, desiredHeight, fbo -> {
                double time = ImGui.getTime();
                double yaw = Math.toRadians(time * 45.0);
                double pitch = Math.toRadians(30.0);

                Quaterniond cameraOrientation = new Quaterniond().rotateX(pitch).rotateY(yaw);
                Vector3d cameraPos = cameraOrientation.transformInverse(new Vector3d(0.0, 0.0, 2.8)).add(0.5, 0.5, 0.5);

                Matrix4f viewMatrix = new Matrix4f().rotate(new Quaternionf(cameraOrientation)).translate((float) -cameraPos.x, (float) -cameraPos.y, (float) -cameraPos.z);

                float aspect = (float) desiredWidth / (float) desiredHeight;
                Matrix4f projMat = new Matrix4f().perspective((float) Math.toRadians(40.0), aspect, 0.3f, 1000.0f);
                Matrix4f modelView = new Matrix4f().mul(viewMatrix);

                class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1590);

                for (class_777 quad : quads) {
                    builder.method_22919(POSE, quad, 1.0F, 1.0F, 1.0F, 1.0F, class_765.field_32767, class_4608.field_21444);
                }

                // draw!
                class_9801 data = builder.method_60794();

                if (data != null) {
                    class_1921 renderType = class_1921.method_23583();
                    Matrix4fStack stack = RenderSystem.getModelViewStack();

                    stack.pushMatrix();
                    stack.set(modelView);
                    RenderSystem.applyModelViewMatrix();
                    RenderSystem.backupProjectionMatrix();
                    RenderSystem.setProjectionMatrix(projMat, class_8251.field_43361);

                    renderType.method_60895(data);

                    stack.popMatrix();
                    RenderSystem.restoreProjectionMatrix();
                    RenderSystem.applyModelViewMatrix();
                    renderType.method_23518();
                }
            });

            if (ImGui.beginChild("3D View", desiredWidth / 2.0F + 2, desiredHeight / 2.0F + 2, false, ImGuiWindowFlags.NoScrollbar)) {
                ImGui.image(texture, desiredWidth / 2.0F, desiredHeight / 2.0F, 0, 1, 1, 0, 1.0F, 1.0F, 1.0F, 1.0F, 1.0F, 1.0F, 1.0F, 0.1F);
            }
            ImGui.endChild();
        }
        ImGui.end();
    }

    @Override
    public boolean isClosed() {
        return !this.open.get();
    }

    @Override
    public BlockModelResource getResource() {
        return this.resource;
    }

    @Override
    public void loadFromDisk() {
        class_310 client = class_310.method_1551();
        this.quads = new ObjectArrayList<>();

        try (Reader reader = resource.resourceInfo().openAsReader(resourceManager)) {
            class_793 unbaked = class_793.method_3437(reader);

            unbaked.method_45785((location) -> {
                try (Reader parentReader = client.method_1478().openAsReader(class_1088.field_40570.method_45112(location))) {
                    return class_793.method_3437(parentReader);
                } catch (Exception e) {
                    Veil.LOGGER.error("Failed to load block model", e);
                    return class_793.method_3430(class_1088.field_5371);
                }
            });

            List<class_785> elements = unbaked.method_3433();

            for (class_785 blockelement : elements) {
                for (class_2350 direction : blockelement.field_4230.keySet()) {
                    class_783 blockelementface = blockelement.field_4230.get(direction);
                    class_4730 material = unbaked.method_24077(blockelementface.comp_2869());
                    class_1058 sprite = client.method_1549(material.method_24144()).apply(material.method_24147());

                    quads.add(FACE_BAKERY.method_3468(blockelement.field_4228, blockelement.field_4231, blockelementface, sprite, direction, class_1086.field_5350, blockelement.field_4232, blockelement.field_4229));
                }
            }
        } catch (Exception e) {
            Veil.LOGGER.error("Failed to load block model", e);
        }
    }
}
