package foundry.veil.api.resource.type;

import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.impl.flare.FlareManager;
import foundry.veil.impl.resource.action.TemplateInspectAction;
import foundry.veil.impl.resource.action.TextEditAction;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3694;

public record FlareResource(VeilResourceInfo resourceInfo) implements VeilTextResource<FlareResource> {

    @Override
    public List<VeilResourceAction<FlareResource>> getActions() {
        return this.resourceInfo.location().method_12832().startsWith("flare/templates") ?
                List.of(new TextEditAction<>(), new TemplateInspectAction<>()) :
                List.of(new TextEditAction<>());
    }

    @Override
    public boolean canHotReload() {
        return true;
    }

    @Override
    public void hotReload(VeilResourceManager resourceManager) throws IOException {
        FlareManager.Reloader.INSTANCE.method_25931(CompletableFuture::completedFuture, resourceManager.resources(this.resourceInfo), class_3694.field_16280, class_3694.field_16280, class_156.method_18349(), class_310.method_1551());
    }

    @Override
    public int getIconCode() {
        return 0xEA1C;
    }

    @Override
    public @Nullable TextEditorLanguageDefinition languageDefinition() {
        return null;
    }
}
