package foundry.veil.api.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3902;

/**
 * @author Ocelot
 */
public final class CompositeReloadListener implements class_3302 {

    private final class_3302[] listeners;

    private CompositeReloadListener(class_3302[] listeners) {
        this.listeners = listeners;
    }

    /**
     * Creates a reload listener that waits for all listeners to complete in stages.
     *
     * @param listeners The listeners to composite together
     * @return A new listener that properly allows listeners to use barriers
     */
    public static class_3302 of(class_3302... listeners) {
        if (listeners.length == 0) {
            return new class_3302() {
                @Override
                public @NotNull CompletableFuture<Void> method_25931(@NotNull class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 prepareProfiler, @NotNull class_3695 applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
                    return preparationBarrier.method_18352(null);
                }

                @Override
                public @NotNull String method_22322() {
                    return "EmptyListener";
                }
            };
        }
        if (listeners.length == 1) {
            return listeners[0];
        }
        return new CompositeReloadListener(listeners);
    }

    @Override
    public @NotNull CompletableFuture<Void> method_25931(@NotNull class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 prepareProfiler, @NotNull class_3695 applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        CompletableFuture<class_3902> allComplete = new CompletableFuture<>();
        Set<class_3302> preparingListeners = new HashSet<>(Arrays.asList(this.listeners));

        List<CompletableFuture<?>> futures = new ArrayList<>(this.listeners.length);
        for (class_3302 listener : this.listeners) {
            class_4045 barrier = new class_4045() {
                @Override
                public <T> @NotNull CompletableFuture<T> method_18352(@Nullable T backgroundResult) {
                    if (preparingListeners.remove(listener) && preparingListeners.isEmpty()) {
                        preparationBarrier.method_18352(null).thenRun(() -> allComplete.complete(class_3902.field_17274));
                    }
                    return allComplete.thenApply(unused -> backgroundResult);
                }
            };
            futures.add(listener.method_25931(barrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor));
        }

        return CompletableFuture.allOf(futures.toArray(CompletableFuture[]::new));
    }

    @Override
    public @NotNull String method_22322() {
        return "CompositeListener[" + Arrays.stream(this.listeners).map(class_3302::method_22322).collect(Collectors.joining(",")) + "]";
    }
}
