package foundry.veil.fabric.mixin.client;

import com.google.common.collect.ImmutableList;
import foundry.veil.fabric.FabricRenderTypeStageHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1921;

@Mixin(class_1921.class)
public class RenderTypeMixin {

    @Shadow
    @Final
    private static ImmutableList<class_1921> CHUNK_BUFFER_LAYERS;

    @Inject(method = "chunkBufferLayers", at = @At("HEAD"), cancellable = true)
    private static void injectChunkBufferLayers(CallbackInfoReturnable<List<class_1921>> cir) {
        List<class_1921> renderTypes = FabricRenderTypeStageHandler.getBlockLayers(CHUNK_BUFFER_LAYERS);
        if (renderTypes != null) {
            cir.setReturnValue(renderTypes);
        }
    }
}
