package foundry.veil.fabric.mixin.compat.sodium;

import foundry.veil.ext.sodium.ChunkVertexEncoderVertexExtension;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkVertexConsumer;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.minecraft.class_4588;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(ChunkVertexConsumer.class)
public class ChunkVertexConsumerMixin {

    @Shadow(remap = false)
    @Final
    private ChunkVertexEncoder.Vertex[] vertices;

    @Shadow(remap = false)
    private int vertexIndex;

    @Inject(method = "setNormal", at = @At("HEAD"))
    public void setNormal(float x, float y, float z, CallbackInfoReturnable<class_4588> cir) {
        ((ChunkVertexEncoderVertexExtension) this.vertices[this.vertexIndex]).veil$setNormal(NormI8.pack(x, y, z));
    }
}
