package foundry.veil.impl;

import foundry.veil.VeilClient;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.impl.flare.FlareManager;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class VeilReloadListeners {
    public static void registerListeners(Context context) {
        context.register(class_3264.field_14188, "quasar", new QuasarParticles.Reloader());
        context.register(class_3264.field_14188, "flare", FlareManager.Reloader.INSTANCE);
        context.register(class_3264.field_14188, "resources", VeilClient.resourceManager().createReloadListener());
    }

    @FunctionalInterface
    public interface Context {

        void register(class_3264 type, String id, class_3302 listener);
    }
}
