package foundry.veil.impl.client.render.light;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.InstancedLightRenderer;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_9801;

@ApiStatus.Internal
public class InstancedPointLightRenderer extends InstancedLightRenderer<PointLightData> {

    private static final class_2960 RENDER_TYPE = Veil.veilPath("light/point");

    public InstancedPointLightRenderer() {
        super(Float.BYTES * 7);
    }

    @Override
    protected class_9801 createMesh() {
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27380, class_290.field_1592);
        LightTypeRenderer.createInvertedCube(builder);
        return builder.method_60800();
    }

    @Override
    protected void setupBufferState(VertexArrayBuilder builder) {
        builder.setVertexAttribute(1, 2, 3, VertexArrayBuilder.DataType.FLOAT, false, 0);
        builder.setVertexAttribute(2, 2, 3, VertexArrayBuilder.DataType.FLOAT, false, Float.BYTES * 3);
        builder.setVertexAttribute(3, 2, 1, VertexArrayBuilder.DataType.FLOAT, false, Float.BYTES * 6);
    }

    @Override
    protected @Nullable class_1921 getRenderType(List<? extends LightRenderHandle<PointLightData>> lights) {
        return VeilRenderType.get(RENDER_TYPE);
    }
}
