package foundry.veil.impl.client.render.pipeline;

import foundry.veil.Veil;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_4668;

@ApiStatus.Internal
public class AdvancedFboShard extends class_4668.class_4678 {

    private final String fboName;

    public AdvancedFboShard(@Nullable class_2960 fboName, Supplier<AdvancedFbo> fbo) {
        super(Veil.MODID + ":advanced_fbo", () -> {
            AdvancedFbo value = fbo.get();
            if (value != null) {
                FramebufferStack.push(fboName);
                value.bind(true);
            }
        }, () -> {
            if (fbo.get() != null) {
                FramebufferStack.pop(fboName);
            }
        });
        this.fboName = fboName != null ? fboName.toString() : "custom";
    }

    @Override
    public String toString() {
        return this.field_21363 + "[" + this.fboName + "]";
    }
}
