package foundry.veil.impl.client.render.shader.block;

import org.jetbrains.annotations.ApiStatus;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;

@ApiStatus.Internal
public class LayoutShaderBlockImpl<T> extends SizedShaderBlockImpl<T> {

    private final Set<class_2960> referencedShaders;

    public LayoutShaderBlockImpl(BufferBinding binding, int size, BiConsumer<T, ByteBuffer> serializer) {
        super(binding, size, serializer);
        this.referencedShaders = new HashSet<>();
    }

    public Set<class_2960> getReferencedShaders() {
        return this.referencedShaders;
    }
}
