package foundry.veil.impl.resource.action;

import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.resource.type.ShellResource;

import java.util.OptionalInt;
import net.minecraft.class_2561;

public record ShellInspectAction<T extends ShellResource>() implements VeilResourceAction<T> {

    private static final class_2561 NAME = class_2561.method_43471("resource.veil.action.shell_edit");
    private static final class_2561 DESC = class_2561.method_43471("resource.veil.action.shell_edit.desc");

    @Override
    public class_2561 getName() {
        return NAME;
    }

    @Override
    public class_2561 getDescription() {
        return DESC;
    }

    @Override
    public OptionalInt getIcon() {
        return OptionalInt.of(0xECDB); // Edit file line icon
    }

    @Override
    public void perform(VeilEditorEnvironment environment, T resource) {
        environment.open(resource, VeilResourceEditorRegistry.SHELL.get());
    }
}
