package foundry.veil.mixin.dynamicbuffer.client;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;

@Mixin(class_757.class)
public class DynamicBufferGameRendererMixin {

    @Shadow
    @Final
    private Map<String, class_5944> shaders;

    @Inject(method = "reloadShaders", at = @At("RETURN"))
    public void reloadShaders(class_5912 resourceProvider, CallbackInfo ci) {
        if (Veil.platform().hasErrors()) {
            return;
        }

        VeilRenderSystem.renderer().getVanillaShaderCompiler().reload(this.shaders.values());
    }
}
