package foundry.veil.mixin.necromancer.client;

import foundry.veil.api.client.necromancer.SkeletonParent;
import foundry.veil.api.client.necromancer.animation.Animator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_638;
import net.minecraft.class_761;

@Mixin(class_761.class)
public class NecromancerLevelRendererMixin {

    @Shadow
    @Nullable
    private class_638 level;

    @SuppressWarnings("rawtypes")
    @Inject(method = "tick", at = @At("HEAD"))
    private void veil$levelRenderTick(CallbackInfo ci) {
        if (this.level == null) {
            return;
        }

        // TODO separate list
        for (class_1297 entity : this.level.method_18112()) {
            if (entity instanceof SkeletonParent parent) {
                Animator animator = parent.getAnimator();
                if (animator != null) {
                    animator.tick();
                }
            }
        }
    }
}
