package foundry.veil.mixin.performance.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4603;
import net.minecraft.class_746;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static org.lwjgl.opengl.GL13C.GL_TEXTURE0;

@Mixin(class_4603.class)
public class PerformanceScreenEffectRendererMixin {

    @Shadow
    @Final
    private static class_2960 UNDERWATER_LOCATION;

    @Unique
    private static final class_2960 BLIT_SCREEN_EFFECT_SHADER = Veil.veilPath("core/blit_screen_effect");

    @Inject(method = "renderTex", at = @At("HEAD"), cancellable = true)
    private static void renderTex(class_1058 texture, class_4587 poseStack, CallbackInfo ci) {
        ShaderProgram shader = VeilRenderSystem.setShader(BLIT_SCREEN_EFFECT_SHADER);
        if (shader == null) {
            return;
        }

        // Faster implementation that does everything on the GPU
        ci.cancel();

        class_310 minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        float xScale;
        float yScale;
        if (window.method_4489() > window.method_4506()) {
            xScale = 1;
            yScale = (float) window.method_4506() / window.method_4489();
        } else {
            xScale = (float) window.method_4489() / window.method_4506();
            yScale = 1;
        }

        ShaderUniform colorModulator = shader.getUniform("ColorModulator");
        if (colorModulator != null) {
            colorModulator.setVector(0.1F, 0.1F, 0.1F, 1.0F);
        }

        ShaderUniform texOffset = shader.getUniform("TexOffset");
        if (texOffset != null) {
            float u0 = texture.method_4594();
            float v0 = texture.method_4593();
            float u1 = texture.method_4577();
            float v1 = texture.method_4575();
            float uWidth = u1 - u0;
            float vHeight = v1 - v0;
            texOffset.setVector(u0 + uWidth * (1.0F - xScale), v0 + vHeight * (1.0F - yScale), uWidth * xScale, vHeight * yScale);
        }

        int activeTexture = GlStateManager._getActiveTexture();
        RenderSystem.activeTexture(GL_TEXTURE0);
        minecraft.method_1531().method_22813(texture.method_45852());

        shader.bind();
        VeilRenderSystem.drawScreenQuad();
        ShaderProgram.unbind();

        RenderSystem.activeTexture(activeTexture);
    }

    @Inject(method = "renderWater", at = @At("HEAD"), cancellable = true)
    private static void renderWater(class_310 minecraft, class_4587 poseStack, CallbackInfo ci) {
        ShaderProgram shader = VeilRenderSystem.setShader(BLIT_SCREEN_EFFECT_SHADER);
        if (shader == null) {
            return;
        }

        // Faster implementation that does everything on the GPU
        ci.cancel();

        class_746 player = minecraft.field_1724;

        ShaderUniform colorModulator = shader.getUniform("ColorModulator");
        if (colorModulator != null) {
            float brightness = class_765.method_23284(player.method_37908().method_8597(), player.method_37908().method_22339(player.method_24515()));
            colorModulator.setVector(brightness, brightness, brightness, 0.1F);
        }

        ShaderUniform texOffset = shader.getUniform("TexOffset");
        if (texOffset != null) {
            class_1041 window = minecraft.method_22683();
            float xScale;
            float yScale;
            if (window.method_4489() > window.method_4506()) {
                xScale = 1;
                yScale = (float) window.method_4506() / window.method_4489();
            } else {
                xScale = (float) window.method_4489() / window.method_4506();
                yScale = 1;
            }

            float u = player.method_36454() / 64.0F;
            float v = -player.method_36455() / 64.0F;

            texOffset.setVector(u + 2.0F * (1.0F - xScale), v + 2.0F * (1.0F - yScale), 2.0F * xScale, 2.0F * yScale);
        }

        int activeTexture = GlStateManager._getActiveTexture();
        RenderSystem.activeTexture(GL_TEXTURE0);
        minecraft.method_1531().method_22813(UNDERWATER_LOCATION);

        RenderSystem.enableBlend();
        shader.bind();
        VeilRenderSystem.drawScreenQuad();
        ShaderProgram.unbind();
        RenderSystem.disableBlend();

        RenderSystem.activeTexture(activeTexture);
    }
}
