package foundry.veil.mixin.pipeline.client;

import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import javax.annotation.Nullable;
import net.minecraft.class_1041;
import net.minecraft.class_2350;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import java.util.Arrays;

@Mixin(class_5944.class)
public abstract class PipelineShaderInstanceMixin {

    @Unique
    private static final class_2350[] veil$DIRECTIONS = class_2350.values();
    @Unique
    private static final String[] veil$FACE_BRIGHTNESS_UNIFORM_NAMES = Arrays.stream(veil$DIRECTIONS)
            .map(direction -> "VeilBlockFaceBrightness[" + direction.method_10146() + "]")
            .toArray(String[]::new);

    @Shadow
    @Nullable
    public abstract class_284 getUniform(String name);

    @Inject(method = "setDefaultUniforms", at = @At("TAIL"))
    public void setDefaultUniforms(class_293.class_5596 mode, Matrix4f projectionMatrix, Matrix4f frustrumMatrix, class_1041 window, CallbackInfo ci) {
        class_284 renderTime = this.getUniform("VeilRenderTime");
        if (renderTime != null) {
            renderTime.method_1251((System.currentTimeMillis() % 3_600_000) / 1000.0F);
        }

        class_284 iModelViewMat = this.getUniform("NormalMat");
        if (iModelViewMat != null) {
            iModelViewMat.method_39978(projectionMatrix.normal(new Matrix3f()));
        }

        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            for (class_2350 value : veil$DIRECTIONS) {
                class_284 uniform = this.getUniform(veil$FACE_BRIGHTNESS_UNIFORM_NAMES[value.ordinal()]);
                if (uniform != null) {
                    uniform.method_1251(level.method_24852(value, true));
                }
            }
        }
    }
}
