package foundry.veil.mixin.rendertype.client;

import com.google.common.collect.ImmutableList;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeAccessor;
import foundry.veil.ext.CompositeStateExtension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_4668;

@Mixin(class_1921.class_4688.class)
public class CompositeStateMixin implements VeilRenderTypeAccessor, CompositeStateExtension {

    @Shadow
    @Final
    class_4668.class_5939 textureState;

    @Shadow
    @Final
    private class_4668.class_5942 shaderState;

    @Shadow
    @Final
    private class_4668.class_4685 transparencyState;

    @Shadow
    @Final
    private class_4668.class_4672 depthTestState;

    @Shadow
    @Final
    class_4668.class_4671 cullState;

    @Shadow
    @Final
    private class_4668.class_4676 lightmapState;

    @Shadow
    @Final
    private class_4668.class_4679 overlayState;

    @Shadow
    @Final
    private class_4668.class_4675 layeringState;

    @Shadow
    @Final
    private class_4668.class_4678 outputState;

    @Shadow
    @Final
    private class_4668.class_4684 texturingState;

    @Shadow
    @Final
    private class_4668.class_4686 writeMaskState;

    @Shadow
    @Final
    private class_4668.class_4677 lineState;

    @Shadow
    @Final
    private class_4668.class_8559 colorLogicState;

    @Shadow
    @Final
    class_1921.class_4750 outlineProperty;

    @Mutable
    @Shadow
    @Final
    ImmutableList<class_4668> states;

    @Override
    public class_4668.class_5939 textureState() {
        return this.textureState;
    }

    @Override
    public class_4668.class_5942 shaderState() {
        return this.shaderState;
    }

    @Override
    public class_4668.class_4685 transparencyState() {
        return this.transparencyState;
    }

    @Override
    public class_4668.class_4672 depthTestState() {
        return this.depthTestState;
    }

    @Override
    public class_4668.class_4671 cullState() {
        return this.cullState;
    }

    @Override
    public class_4668.class_4676 lightmapState() {
        return this.lightmapState;
    }

    @Override
    public class_4668.class_4679 overlayState() {
        return this.overlayState;
    }

    @Override
    public class_4668.class_4675 layeringState() {
        return this.layeringState;
    }

    @Override
    public class_4668.class_4678 outputState() {
        return this.outputState;
    }

    @Override
    public class_4668.class_4684 texturingState() {
        return this.texturingState;
    }

    @Override
    public class_4668.class_4686 writeMaskState() {
        return this.writeMaskState;
    }

    @Override
    public class_4668.class_4677 lineState() {
        return this.lineState;
    }

    @Override
    public class_4668.class_8559 colorLogicState() {
        return this.colorLogicState;
    }

    @Override
    public class_1921.class_4750 outlineProperty() {
        return this.outlineProperty;
    }

    @Override
    public List<class_4668> states() {
        return this.states;
    }

    @Override
    public void veil$addShards(Collection<class_4668> shards) {
        if (shards.isEmpty()) {
            return;
        }

        ImmutableList.Builder<class_4668> builder = new ImmutableList.Builder<>();
        builder.addAll(this.states);
        builder.addAll(shards);
        this.states = builder.build();
    }
}
