/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.imgui;

import foundry.veil.Veil;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.extension.texteditor.TextEditor;
import imgui.extension.texteditor.TextEditorCoordinates;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class CodeEditor
implements NativeResource {
    private static final Component EDITOR = Component.translatable((String)"editor.veil.default");
    private final Component name;
    private final TextEditor editor;
    private final Component saveText;
    private CharSequence oldSource;
    private SaveCallback saveCallback;
    private String fileName;
    private final ImBoolean open;

    public CodeEditor(@Nullable Component saveText) {
        this(EDITOR, saveText);
    }

    public CodeEditor(Component name, @Nullable Component saveText) {
        this.name = name;
        this.editor = new TextEditor();
        this.editor.setShowWhitespaces(false);
        this.saveText = saveText;
        this.oldSource = null;
        this.saveCallback = null;
        this.open = new ImBoolean();
    }

    public boolean hasTextChanged() {
        return this.oldSource != null && !this.oldSource.equals(this.editor.getText());
    }

    public void save() {
        Int2ObjectArrayMap errors = new Int2ObjectArrayMap();
        if (this.saveCallback != null) {
            this.saveCallback.save(this.editor.getText(), (Int2ObjectMap<String>)errors);
        }
        if (errors.isEmpty()) {
            this.oldSource = this.editor.getText();
        }
        Veil.withImGui(() -> this.lambda$save$0((Int2ObjectMap)errors));
    }

    public void show(@Nullable String fileName, String source) {
        this.editor.setText(source);
        this.fileName = fileName;
        this.oldSource = this.editor.getText();
        this.editor.setErrorMarkers(Collections.emptyMap());
        this.open.set(true);
        Veil.withImGui(() -> {
            ImGui.setWindowFocus((String)"###editor");
            ImGui.setWindowCollapsed((String)"###editor", (boolean)false);
        });
    }

    public void hide() {
        if (this.hasTextChanged()) {
            this.open.set(true);
            Veil.withImGui(() -> {
                ImGui.pushID((int)this.hashCode());
                ImGui.openPopup((String)"###save_confirm");
                ImGui.popID();
            });
        } else {
            this.oldSource = null;
            this.open.set(false);
        }
    }

    public void renderWindow() {
        int flags = 1280;
        if (!this.editor.isReadOnly() && this.hasTextChanged()) {
            flags |= 0x100000;
        }
        if (!this.open.get()) {
            return;
        }
        int id = this.hashCode();
        ImGui.pushID((int)id);
        ImGui.setNextWindowSizeConstraints((float)800.0f, (float)600.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        if (ImGui.begin((String)(this.name.getString() + (String)(this.fileName != null ? ": " + this.fileName : "") + "###editor" + id), (ImBoolean)this.open, (int)flags)) {
            this.render();
        }
        if (!this.open.get()) {
            this.hide();
        }
        ImGui.end();
        ImGui.popID();
    }

    public void render() {
        String save;
        ImGui.pushID((int)this.hashCode());
        if (this.open.get()) {
            if (!this.hasTextChanged()) {
                this.editor.setErrorMarkers(Collections.emptyMap());
            }
            if (ImGui.beginMenuBar()) {
                boolean immutable = this.editor.isReadOnly();
                if (ImGui.menuItem((String)"Read-only mode", (String)"", (boolean)immutable)) {
                    this.editor.setReadOnly(!immutable);
                }
                if (ImGui.menuItem((String)"Show Whitespace", (String)"", (boolean)this.editor.isShowingWhitespaces())) {
                    this.editor.setShowWhitespaces(!this.editor.isShowingWhitespaces());
                }
                if (this.saveText != null && ImGui.menuItem((String)this.saveText.getString())) {
                    this.save();
                }
                ImGui.separator();
                ImGui.beginDisabled((boolean)immutable);
                ImGui.beginDisabled((!this.editor.canUndo() ? 1 : 0) != 0);
                if (ImGui.menuItem((String)"Undo", (String)"ALT-Backspace")) {
                    this.editor.undo(1);
                }
                ImGui.endDisabled();
                ImGui.beginDisabled((!this.editor.canRedo() ? 1 : 0) != 0);
                if (ImGui.menuItem((String)"Redo", (String)"Ctrl-Y")) {
                    this.editor.redo(1);
                }
                ImGui.endDisabled();
                ImGui.endDisabled();
                ImGui.separator();
                ImGui.beginDisabled((!this.editor.hasSelection() ? 1 : 0) != 0);
                if (ImGui.menuItem((String)"Copy", (String)"Ctrl-C")) {
                    this.editor.copy();
                }
                ImGui.endDisabled();
                ImGui.beginDisabled((boolean)immutable);
                ImGui.beginDisabled((!this.editor.hasSelection() ? 1 : 0) != 0);
                if (ImGui.menuItem((String)"Cut", (String)"Ctrl-X")) {
                    this.editor.cut();
                }
                if (ImGui.menuItem((String)"Delete", (String)"Del")) {
                    this.editor.delete();
                }
                ImGui.endDisabled();
                ImGui.beginDisabled((ImGui.getClipboardText() == null ? 1 : 0) != 0);
                if (ImGui.menuItem((String)"Paste", (String)"Ctrl-V")) {
                    this.editor.paste();
                }
                ImGui.endDisabled();
                ImGui.endDisabled();
                ImGui.endMenuBar();
            }
            TextEditorCoordinates pos = this.editor.getCursorPosition();
            int cposX = pos.mLine;
            int cposY = pos.mColumn;
            String overwrite = this.editor.isOverwrite() ? "Ovr" : "Ins";
            String canUndo = this.editor.canUndo() ? "*" : " ";
            ImGui.text((String)(cposX + ":" + cposY + " " + this.editor.getTotalLines() + " lines | " + overwrite + " | " + canUndo));
            this.editor.render("TextEditor");
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos((float)center.x, (float)center.y, (int)8, (float)0.5f, (float)0.5f);
        if (this.saveText != null && ImGui.beginPopupModal((String)((save = this.saveText.getString()) + "?###save_confirm"), (int)64)) {
            ImGui.text((String)"Your changes have not been saved.\nThis operation cannot be undone!");
            ImGui.separator();
            ImGui.setItemDefaultFocus();
            if (ImGui.button((String)save)) {
                this.save();
                this.hide();
                ImGui.closeCurrentPopup();
            }
            ImGui.sameLine();
            if (ImGui.button((String)"Discard")) {
                this.oldSource = null;
                this.hide();
                ImGui.closeCurrentPopup();
            }
            ImGui.sameLine();
            if (ImGui.button((String)"Cancel")) {
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
        ImGui.popID();
    }

    public TextEditor getEditor() {
        return this.editor;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public void setSaveCallback(@Nullable SaveCallback saveCallback) {
        this.saveCallback = saveCallback;
    }

    public void free() {
        this.editor.destroy();
    }

    private /* synthetic */ void lambda$save$0(Int2ObjectMap errors) {
        this.editor.setErrorMarkers((Map)errors);
    }

    @FunctionalInterface
    public static interface SaveCallback {
        public void save(String var1, Int2ObjectMap<String> var2);
    }
}

