/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.pipeline.AdvancedFboShard;
import foundry.veil.impl.client.render.pipeline.FlagShards;
import foundry.veil.impl.client.render.pipeline.PatchStateShard;
import foundry.veil.impl.client.render.pipeline.ShaderProgramShard;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import foundry.veil.impl.client.render.wrapper.DSAVanillaAdvancedFboWrapper;
import foundry.veil.impl.client.render.wrapper.LegacyVanillaAdvancedFboWrapper;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;

public interface VeilRenderBridge {
    public static ShaderInstance toShaderInstance(ShaderProgram program) {
        return ((ShaderProgramImpl)program).toShaderInstance();
    }

    public static CullFrustum create(Frustum frustum) {
        return (CullFrustum)frustum;
    }

    public static VeilRenderTypeBuilder create(RenderType.CompositeState.CompositeStateBuilder builder) {
        return (VeilRenderTypeBuilder)builder;
    }

    public static MatrixStack create(PoseStack poseStack) {
        return (MatrixStack)poseStack;
    }

    public static AdvancedFbo wrap(RenderTarget renderTarget) {
        return VeilRenderBridge.wrap(() -> renderTarget);
    }

    public static AdvancedFbo wrap(Supplier<RenderTarget> renderTargetSupplier) {
        return VeilRenderSystem.directStateAccessSupported() ? new DSAVanillaAdvancedFboWrapper(renderTargetSupplier) : new LegacyVanillaAdvancedFboWrapper(renderTargetSupplier);
    }

    public static RenderStateShard.ShaderStateShard shaderState(ResourceLocation shader) {
        return new ShaderProgramShard(shader);
    }

    public static RenderStateShard.OutputStateShard outputState(ResourceLocation framebuffer) {
        return new AdvancedFboShard(framebuffer, () -> VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(framebuffer));
    }

    public static RenderStateShard.OutputStateShard outputState(AdvancedFbo framebuffer) {
        return new AdvancedFboShard(null, () -> framebuffer);
    }

    public static RenderStateShard.OutputStateShard outputState(Supplier<AdvancedFbo> framebuffer) {
        return new AdvancedFboShard(null, framebuffer);
    }

    public static RenderStateShard patchState(int patchVertices) {
        return new PatchStateShard(patchVertices);
    }

    public static RenderStateShard depthClampState() {
        return FlagShards.DEPTH_CLAMP;
    }

    public static RenderStateShard ditherState() {
        return FlagShards.DITHER;
    }

    public static RenderStateShard lineSmoothState() {
        return FlagShards.LINE_SMOOTH;
    }

    public static RenderStateShard multisampleState() {
        return FlagShards.MULTISAMPLE;
    }

    public static RenderStateShard seamlessCubeMapState() {
        return FlagShards.TEXTURE_CUBE_MAP_SEAMLESS;
    }
}

