/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import io.github.ocelot.glslprocessor.api.grammar.GlslSpecifiedType;
import io.github.ocelot.glslprocessor.api.grammar.GlslStructField;
import io.github.ocelot.glslprocessor.api.grammar.GlslStructSpecifier;
import io.github.ocelot.glslprocessor.api.grammar.GlslType;
import io.github.ocelot.glslprocessor.api.grammar.GlslTypeQualifier;
import io.github.ocelot.glslprocessor.api.grammar.GlslTypeSpecifier;
import io.github.ocelot.glslprocessor.api.node.GlslNode;
import io.github.ocelot.glslprocessor.api.node.variable.GlslNewFieldNode;
import io.github.ocelot.glslprocessor.api.node.variable.GlslStructDeclarationNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2dc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4dc;
import org.joml.Vector4fc;
import org.joml.Vector4ic;

public record VeilShaderBufferLayout<T>(String name, Map<String, FieldSerializer<T>> fields, ShaderBlock.BufferBinding requestedBinding, ShaderBlock.MemoryLayout memoryLayout, GlslStructSpecifier structSpecifier) {
    public GlslNode createNode(boolean shaderStorageSupported, @Nullable String interfaceName) {
        GlslTypeQualifier.StorageType storageType = switch (this.requestedBinding) {
            default -> throw new MatchException(null, null);
            case ShaderBlock.BufferBinding.UNIFORM -> GlslTypeQualifier.StorageType.UNIFORM;
            case ShaderBlock.BufferBinding.SHADER_STORAGE -> shaderStorageSupported ? GlslTypeQualifier.StorageType.BUFFER : GlslTypeQualifier.StorageType.UNIFORM;
        };
        GlslSpecifiedType structSpecifier = new GlslSpecifiedType((GlslTypeSpecifier)this.structSpecifier, new GlslTypeQualifier[]{GlslTypeQualifier.layout((GlslTypeQualifier.LayoutId[])new GlslTypeQualifier.LayoutId[]{this.memoryLayout.getLayoutId()}), storageType});
        Object node = interfaceName != null ? new GlslNewFieldNode((GlslType)structSpecifier, interfaceName, null) : new GlslStructDeclarationNode(structSpecifier);
        return node;
    }

    public ShaderBlock.BufferBinding binding() {
        return VeilRenderSystem.shaderStorageBufferSupported() ? this.requestedBinding : ShaderBlock.BufferBinding.UNIFORM;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private static final Random RANDOM = new Random();
        private final String name = "VeilBuffer" + Math.abs(RANDOM.nextInt());
        private final List<GlslStructField> structFields = new ArrayList<GlslStructField>();
        private final Map<String, FieldSerializer<T>> fields = new Object2ObjectArrayMap();
        private ShaderBlock.BufferBinding binding = ShaderBlock.BufferBinding.UNIFORM;
        private ShaderBlock.MemoryLayout memoryLayout = ShaderBlock.MemoryLayout.SHARED;

        public Builder<T> binding(ShaderBlock.BufferBinding binding) {
            this.binding = binding;
            return this;
        }

        public Builder<T> memoryLayout(ShaderBlock.MemoryLayout memoryLayout) {
            this.memoryLayout = memoryLayout;
            return this;
        }

        public Builder<T> f32(String name, FloatSerializer<T> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.FLOAT, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putFloat(index, serializer.serialize(value)));
            return this;
        }

        public Builder<T> f64(String name, DoubleSerializer<T> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DOUBLE, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putDouble(index, serializer.serialize(value)));
            return this;
        }

        public Builder<T> integer(String name, IntSerializer<T> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.INT, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, serializer.serialize(value)));
            return this;
        }

        public Builder<T> uint(String name, IntSerializer<T> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.UINT, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, serializer.serialize(value)));
            return this;
        }

        public Builder<T> vec2(String name, Function<T, Vector2fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.VEC2, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector2fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> vec2(String name, FloatSerializer<T> x, FloatSerializer<T> y) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.VEC2, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putFloat(index, x.serialize(value)).putFloat(index + 4, y.serialize(value)));
            return this;
        }

        public Builder<T> vec3(String name, Function<T, Vector3fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.VEC3, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector3fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> vec3(String name, FloatSerializer<T> x, FloatSerializer<T> y, FloatSerializer<T> z) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.VEC3, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putFloat(index, x.serialize(value)).putFloat(index + 4, y.serialize(value)).putFloat(index + 8, z.serialize(value)));
            return this;
        }

        public Builder<T> vec4(String name, Function<T, Vector4fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.VEC4, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector4fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> vec4(String name, FloatSerializer<T> x, FloatSerializer<T> y, FloatSerializer<T> z, FloatSerializer<T> w) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.VEC4, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putFloat(index, x.serialize(value)).putFloat(index + 4, y.serialize(value)).putFloat(index + 8, z.serialize(value)).putFloat(index + 12, w.serialize(value)));
            return this;
        }

        public Builder<T> dvec2(String name, Function<T, Vector2dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DVEC2, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector2dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dvec2(String name, DoubleSerializer<T> x, DoubleSerializer<T> y) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DVEC2, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putDouble(index, x.serialize(value)).putDouble(index + 8, y.serialize(value)));
            return this;
        }

        public Builder<T> dvec3(String name, Function<T, Vector3dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DVEC3, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector3dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dvec3(String name, DoubleSerializer<T> x, DoubleSerializer<T> y, DoubleSerializer<T> z) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DVEC3, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putDouble(index, x.serialize(value)).putDouble(index + 8, y.serialize(value)).putDouble(index + 16, z.serialize(value)));
            return this;
        }

        public Builder<T> dvec4(String name, Function<T, Vector4dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DVEC4, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector4dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dvec4(String name, DoubleSerializer<T> x, DoubleSerializer<T> y, DoubleSerializer<T> z, DoubleSerializer<T> w) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DVEC4, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putDouble(index, x.serialize(value)).putDouble(index + 8, y.serialize(value)).putDouble(index + 16, z.serialize(value)).putDouble(index + 24, w.serialize(value)));
            return this;
        }

        public Builder<T> ivec2(String name, Function<T, Vector2ic> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.IVEC2, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector2ic)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> ivec2(String name, IntSerializer<T> x, IntSerializer<T> y) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.IVEC2, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, x.serialize(value)).putInt(index + 4, y.serialize(value)));
            return this;
        }

        public Builder<T> ivec3(String name, Function<T, Vector3ic> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.IVEC3, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector3ic)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> ivec3(String name, IntSerializer<T> x, IntSerializer<T> y, IntSerializer<T> z) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.IVEC3, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, x.serialize(value)).putInt(index + 4, y.serialize(value)).putInt(index + 8, z.serialize(value)));
            return this;
        }

        public Builder<T> ivec4(String name, Function<T, Vector4ic> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.IVEC4, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector4ic)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> ivec4(String name, IntSerializer<T> x, IntSerializer<T> y, IntSerializer<T> z, IntSerializer<T> w) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.IVEC4, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, x.serialize(value)).putInt(index + 4, y.serialize(value)).putInt(index + 8, z.serialize(value)).putInt(index + 12, w.serialize(value)));
            return this;
        }

        public Builder<T> uvec2(String name, Function<T, Vector2ic> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.UVEC2, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector2ic)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> uvec2(String name, IntSerializer<T> x, IntSerializer<T> y) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.UVEC2, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, x.serialize(value)).putInt(index + 4, y.serialize(value)));
            return this;
        }

        public Builder<T> uvec3(String name, Function<T, Vector3ic> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.UVEC3, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector3ic)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> uvec3(String name, IntSerializer<T> x, IntSerializer<T> y, IntSerializer<T> z) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.UVEC3, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, x.serialize(value)).putInt(index + 4, y.serialize(value)).putInt(index + 8, z.serialize(value)));
            return this;
        }

        public Builder<T> uvec4(String name, Function<T, Vector4ic> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.UVEC4, name));
            this.fields.put(name, (value, index, buffer) -> ((Vector4ic)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> uvec4(String name, IntSerializer<T> x, IntSerializer<T> y, IntSerializer<T> z, IntSerializer<T> w) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.UVEC4, name));
            this.fields.put(name, (value, index, buffer) -> buffer.putInt(index, x.serialize(value)).putInt(index + 4, y.serialize(value)).putInt(index + 8, z.serialize(value)).putInt(index + 12, w.serialize(value)));
            return this;
        }

        public Builder<T> mat2(String name, Function<T, Matrix2fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.MAT2, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix2fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> mat3(String name, Function<T, Matrix3fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.MAT3, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix3fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> mat4(String name, Function<T, Matrix4fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.MAT4, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix4fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> mat3x2(String name, Function<T, Matrix3x2fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.MAT3X2, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix3x2fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> mat4x3(String name, Function<T, Matrix4x3fc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.MAT4X3, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix4x3fc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dmat2(String name, Function<T, Matrix2dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DMAT2, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix2dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dmat3(String name, Function<T, Matrix3dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DMAT3, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix3dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dmat4(String name, Function<T, Matrix4dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DMAT4, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix4dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dmat3x2(String name, Function<T, Matrix3x2dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DMAT3X2, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix3x2dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public Builder<T> dmat4x3(String name, Function<T, Matrix4x3dc> serializer) {
            this.structFields.add(new GlslStructField((GlslType)GlslTypeSpecifier.BuiltinType.DMAT4X3, name));
            this.fields.put(name, (value, index, buffer) -> ((Matrix4x3dc)serializer.apply(value)).get(index, buffer));
            return this;
        }

        public VeilShaderBufferLayout<T> build() {
            if (this.memoryLayout == ShaderBlock.MemoryLayout.STD430 && this.binding != ShaderBlock.BufferBinding.SHADER_STORAGE) {
                throw new IllegalArgumentException("std430 only supports shader storage buffers");
            }
            if (this.fields.isEmpty()) {
                throw new IllegalArgumentException("At least 1 field must be defined in a shader block");
            }
            return new VeilShaderBufferLayout<T>(this.name, Collections.unmodifiableMap(this.fields), this.binding, this.memoryLayout, GlslTypeSpecifier.struct((String)this.name, this.structFields));
        }

        @FunctionalInterface
        public static interface FloatSerializer<T> {
            public float serialize(T var1);
        }

        @FunctionalInterface
        public static interface DoubleSerializer<T> {
            public double serialize(T var1);
        }

        @FunctionalInterface
        public static interface IntSerializer<T> {
            public int serialize(T var1);
        }
    }

    @FunctionalInterface
    public static interface FieldSerializer<T> {
        public void write(T var1, int var2, ByteBuffer var3);
    }
}

