/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryStack;

public class FramebufferStack {
    private static final List<State> STATE_STACK = new ArrayList<State>(1);
    private static ResourceLocation lastPop;

    public static void push(@Nullable ResourceLocation name) {
        if (name != null && !STATE_STACK.isEmpty() && name.equals((Object)FramebufferStack.STATE_STACK.getLast().name)) {
            return;
        }
        Vector4i viewport = new Vector4i();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer bufer = stack.mallocInt(4);
            GL30C.glGetIntegerv((int)2978, (IntBuffer)bufer);
            viewport.set(bufer);
        }
        STATE_STACK.add(new State(viewport, GL30C.glGetInteger((int)36006), GL30C.glGetInteger((int)36010), GL30C.glGetInteger((int)36006), name));
        lastPop = null;
    }

    public static void pop(@Nullable ResourceLocation name) {
        if (lastPop != null && lastPop.equals((Object)name)) {
            return;
        }
        if (STATE_STACK.isEmpty()) {
            Veil.LOGGER.error("Popped empty Framebuffer stack");
            lastPop = null;
            return;
        }
        lastPop = name;
        State state = STATE_STACK.removeFirst();
        if (state.framebuffer == AdvancedFbo.getMainFramebuffer().getId()) {
            AdvancedFbo.unbind();
            return;
        }
        Vector4i viewport = state.viewport;
        GlStateManager._glBindFramebuffer((int)36160, (int)state.framebuffer);
        GlStateManager._glBindFramebuffer((int)36008, (int)state.readFramebuffer);
        GlStateManager._glBindFramebuffer((int)36009, (int)state.drawFramebuffer);
        RenderSystem.viewport((int)viewport.x, (int)viewport.y, (int)viewport.z, (int)viewport.w);
    }

    public static void clear() {
        if (!STATE_STACK.isEmpty()) {
            STATE_STACK.clear();
            AdvancedFbo.unbind();
            lastPop = null;
        }
    }

    public static boolean isEmpty() {
        return STATE_STACK.isEmpty();
    }

    private record State(Vector4i viewport, int framebuffer, int readFramebuffer, int drawFramebuffer, @Nullable ResourceLocation name) {
    }
}

