/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.light.InstancedLightData;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class InstancedLightRenderer<T extends LightData>
implements LightTypeRenderer<T> {
    private static final int MAX_UPLOADS = 400;
    protected final int lightSize;
    protected int maxLights;
    private final List<LightHandle> lights;
    private final List<LightHandle> visibleLights;
    private final VertexArray vertexArray;
    private final int instancedVbo;
    private boolean freed;

    public InstancedLightRenderer(int lightSize) {
        this.lightSize = lightSize;
        this.maxLights = 0;
        this.lights = new LinkedList<LightHandle>();
        this.visibleLights = new LinkedList<LightHandle>();
        this.vertexArray = VertexArray.create();
        MeshData mesh = this.createMesh();
        this.vertexArray.upload(mesh, VertexArray.DrawUsage.STATIC);
        this.instancedVbo = this.vertexArray.getOrCreateBuffer(2);
        VertexArrayBuilder builder = this.vertexArray.editFormat();
        builder.defineVertexBuffer(2, this.instancedVbo, 0, this.lightSize, 1);
        this.setupBufferState(builder);
    }

    protected abstract MeshData createMesh();

    protected abstract void setupBufferState(VertexArrayBuilder var1);

    @Nullable
    protected abstract RenderType getRenderType(List<? extends LightRenderHandle<T>> var1);

    private void updateAllLights() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int pointer = 0;
            long offset = 0L;
            ByteBuffer dataBuffer = stack.malloc(Math.min(400, this.visibleLights.size()) * this.lightSize);
            for (LightHandle handle : this.visibleLights) {
                dataBuffer.position(pointer++ * this.lightSize);
                ((InstancedLightData)handle.data).store(dataBuffer);
                if (pointer < 400) continue;
                dataBuffer.rewind();
                GL15C.glBufferSubData((int)34962, (long)offset, (ByteBuffer)dataBuffer);
                offset += (long)dataBuffer.capacity();
                pointer = 0;
            }
            if (pointer > 0) {
                dataBuffer.rewind();
                GL15C.nglBufferSubData((int)34962, (long)offset, (long)((long)pointer * (long)this.lightSize), (long)MemoryUtil.memAddress((ByteBuffer)dataBuffer));
            }
        }
    }

    @Override
    public LightRenderHandle<T> addLight(T light) {
        LightHandle handle = new LightHandle(this, light);
        this.lights.add(handle);
        return handle;
    }

    @Override
    public LightRenderHandle<T> steal(LightRenderHandle<T> handle) {
        if (!(handle instanceof LightHandle)) {
            handle.free();
            return this.addLight(handle.getLightData());
        }
        return handle;
    }

    @Override
    public void prepareLights(LightRenderer lightRenderer, CullFrustum frustum) {
        this.visibleLights.clear();
        for (LightHandle light : this.lights) {
            if (!((LightData)light.data).isVisible(frustum)) continue;
            this.visibleLights.add(light);
        }
    }

    @Override
    public void renderLights(LightRenderer lightRenderer) {
        if (this.visibleLights.isEmpty()) {
            return;
        }
        RenderType renderType = this.getRenderType(this.visibleLights);
        if (renderType == null) {
            return;
        }
        RenderSystem.glBindBuffer((int)34962, (int)this.instancedVbo);
        if (this.visibleLights.size() > this.maxLights) {
            this.maxLights = this.maxLights < 100 ? 100 : (int)Math.max(Math.ceil((double)this.maxLights / 2.0), (double)this.visibleLights.size() * 1.5);
            GL15C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35040);
        }
        this.updateAllLights();
        this.vertexArray.bind();
        this.vertexArray.drawInstancedWithRenderType(renderType, this.visibleLights.size());
    }

    public List<? extends LightRenderHandle<T>> getLights() {
        return this.lights;
    }

    @Override
    public int getVisibleLights() {
        return this.visibleLights.size();
    }

    public void free() {
        this.vertexArray.free();
        this.freed = true;
    }

    private static class LightHandle
    implements LightRenderHandle<T> {
        private final T data;
        final /* synthetic */ InstancedLightRenderer this$0;

        private LightHandle(T data) {
            this.this$0 = var1_1;
            this.data = data;
        }

        @Override
        public T getLightData() {
            return this.data;
        }

        @Override
        public void markDirty() {
        }

        @Override
        public boolean isValid() {
            return !this.this$0.freed;
        }

        public void free() {
            this.this$0.lights.remove(this);
        }
    }
}

