/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.vertex.VertexArray;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public final class LightRenderer
implements NativeResource {
    private static final ResourceLocation BUFFER_ID = Veil.veilPath("lights");
    private final Map<LightTypeRegistry.LightType<?>, LightTypeRenderer<?>> renderers = new Object2ObjectArrayMap();
    private boolean ambientOcclusionEnabled = true;

    @ApiStatus.Internal
    public boolean render(CullFrustum frustum, AdvancedFbo lightFbo) {
        boolean hasRendered = false;
        VeilRenderer renderer = VeilRenderSystem.renderer();
        for (LightTypeRenderer<?> lightRenderer : this.renderers.values()) {
            lightRenderer.prepareLights(this, frustum);
            if (lightRenderer.getVisibleLights() <= 0) continue;
            if (!hasRendered) {
                lightFbo.bind(true);
                lightFbo.clear(16384);
                AdvancedFbo.getMainFramebuffer().resolveToAdvancedFbo(lightFbo, 256, 9728);
            }
            hasRendered = true;
            if (renderer.enableBuffers(BUFFER_ID, DynamicBufferType.ALBEDO, DynamicBufferType.NORMAL)) break;
            lightRenderer.renderLights(this);
        }
        if (!hasRendered) {
            renderer.disableBuffers(BUFFER_ID, DynamicBufferType.ALBEDO, DynamicBufferType.NORMAL);
            return false;
        }
        VertexArray.unbind();
        return true;
    }

    public <T extends LightData> LightRenderHandle<T> addLight(T lightData) {
        Objects.requireNonNull(lightData, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        return this.renderers.computeIfAbsent(lightData.getType(), lightType -> lightType.rendererFactory().createRenderer()).addLight(lightData);
    }

    public <T extends LightData> LightRenderHandle<T> addLight(LightRenderHandle<T> handle) {
        Objects.requireNonNull(handle, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        return this.renderers.computeIfAbsent(((LightData)handle.getLightData()).getType(), lightType -> lightType.rendererFactory().createRenderer()).steal(handle);
    }

    public <T extends LightData> Collection<? extends LightRenderHandle<T>> getLights(LightTypeRegistry.LightType<? extends T> type) {
        LightTypeRenderer<?> renderer = this.renderers.get(type);
        return renderer != null ? renderer.getLights() : Collections.emptyList();
    }

    @Deprecated(since="2.3.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public void enableAmbientOcclusion() {
        if (!this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = true;
            VeilRenderSystem.rebuildChunks();
        }
    }

    @Deprecated(since="2.3.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public void disableAmbientOcclusion() {
        if (this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = false;
            VeilRenderSystem.rebuildChunks();
        }
    }

    @Deprecated(since="2.3.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public boolean isAmbientOcclusionEnabled() {
        return this.ambientOcclusionEnabled;
    }

    public void free() {
        this.renderers.values().forEach(NativeResource::free);
        this.renderers.clear();
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        int visible = 0;
        int all = 0;
        for (LightTypeRenderer<?> renderer : this.renderers.values()) {
            visible += renderer.getVisibleLights();
            all += renderer.getLights().size();
        }
        consumer.accept("Lights: " + visible + " / " + all);
    }
}

