/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post;

import com.mojang.serialization.Codec;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.program.MutableUniformAccess;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.program.TextureUniformAccess;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import foundry.veil.api.client.render.shader.uniform.ShaderUniformAccess;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public interface PostPipeline
extends MutableUniformAccess,
NativeResource {
    public static final Codec<PostPipeline> CODEC = PostPipelineStageRegistry.REGISTRY.byNameCodec().dispatch(PostPipeline::getType, PostPipelineStageRegistry.PipelineType::codec);

    @ApiStatus.OverrideOnly
    public void apply(Context var1);

    default public void free() {
    }

    public PostPipelineStageRegistry.PipelineType<? extends PostPipeline> getType();

    @Override
    default public int getUniformLocation(CharSequence name) {
        throw new UnsupportedOperationException("Cannot get values from post pipelines");
    }

    @Override
    @Nullable
    default public ShaderUniformAccess getUniform(CharSequence name) {
        return null;
    }

    @Override
    default public ShaderUniformAccess getUniformSafe(CharSequence name) {
        return ShaderUniformAccess.EMPTY;
    }

    @Override
    default public ShaderUniformAccess getOrCreateUniform(CharSequence name) {
        return ShaderUniformAccess.EMPTY;
    }

    @Override
    default public int getUniformBlock(CharSequence name) {
        throw new UnsupportedOperationException("Cannot get values from post pipelines");
    }

    @Override
    default public int getStorageBlock(CharSequence name) {
        throw new UnsupportedOperationException("Cannot get values from post pipelines");
    }

    @Override
    default public boolean hasUniform(CharSequence name) {
        return false;
    }

    @Override
    default public boolean hasUniformBlock(CharSequence name) {
        return false;
    }

    @Override
    default public boolean hasStorageBlock(CharSequence name) {
        return false;
    }

    @Override
    default public void setUniformBlock(CharSequence name, int binding) {
    }

    @Override
    default public void setStorageBlock(CharSequence name, int binding) {
    }

    @ApiStatus.NonExtendable
    public static interface Context
    extends ShaderTextureSource.Context {
        public void setSampler(CharSequence var1, int var2, int var3);

        public void setFramebuffer(ResourceLocation var1, AdvancedFbo var2);

        public void applySamplers(TextureUniformAccess var1);

        public void clearSamplers(TextureUniformAccess var1);

        default public AdvancedFbo getFramebufferOrDraw(ResourceLocation name) {
            AdvancedFbo fbo = this.getFramebuffer(name);
            return fbo != null ? fbo : this.getDrawFramebuffer();
        }

        public AdvancedFbo getDrawFramebuffer();

        @Nullable
        default public PostPipeline getPipeline(ResourceLocation name) {
            return VeilRenderSystem.renderer().getPostProcessingManager().getPipeline(name);
        }

        @Nullable
        default public ShaderProgram getShader(ResourceLocation name) {
            return VeilRenderSystem.renderer().getShaderManager().getShader(name);
        }
    }
}

