/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.stage;

import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class FramebufferPostStage
implements PostPipeline {
    private final ResourceLocation in;
    private final ResourceLocation out;
    private final boolean clear;

    public FramebufferPostStage(@Nullable ResourceLocation in, ResourceLocation out, boolean clear) {
        this.in = in;
        this.out = out;
        this.clear = clear;
    }

    protected void setupFramebuffer(PostPipeline.Context context, ShaderProgram shader) {
        ShaderUniform outSize;
        ShaderUniform inSize;
        AdvancedFbo in = this.in != null ? context.getFramebuffer(this.in) : null;
        AdvancedFbo out = context.getFramebufferOrDraw(this.out);
        if (in != null) {
            shader.setFramebufferSamplers(in);
        }
        out.bind(true);
        if (this.clear) {
            out.clear();
        }
        if ((inSize = shader.getUniform("InSize")) != null) {
            if (in != null) {
                inSize.setVector(in.getWidth(), in.getHeight());
            } else {
                inSize.setVector(1.0f, 1.0f);
            }
        }
        if ((outSize = shader.getUniform("OutSize")) != null) {
            outSize.setVector(out.getWidth(), out.getHeight());
        }
    }

    @Nullable
    public ResourceLocation getIn() {
        return this.in;
    }

    public ResourceLocation getOut() {
        return this.out;
    }

    public boolean clearOut() {
        return this.clear;
    }
}

