/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.uniform;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.render.post.uniform.UniformValue;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import java.util.ArrayList;

public record FloatUniform(float[] values) implements UniformValue
{
    public static final MapCodec<FloatUniform> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.listOf(1, 4).xmap(floats -> {
        float[] values = new float[floats.size()];
        for (int i = 0; i < floats.size(); ++i) {
            values[i] = ((Float)floats.get(i)).floatValue();
        }
        return values;
    }, values -> {
        ArrayList<Float> floats = new ArrayList<Float>(((float[])values).length);
        for (float value : values) {
            floats.add(Float.valueOf(value));
        }
        return floats;
    }).fieldOf("value").forGetter(FloatUniform::values)).apply((Applicative)instance, FloatUniform::new));

    @Override
    public void apply(ShaderUniform uniform) {
        uniform.setVector(this.values);
    }

    @Override
    public UniformValue.Type type() {
        return UniformValue.Type.FLOAT;
    }
}

