/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeAccessor;
import foundry.veil.api.client.render.vertex.VeilVertexFormat;
import foundry.veil.impl.client.render.pipeline.CullFaceShard;
import foundry.veil.mixin.rendertype.accessor.RenderStateShardAccessor;
import foundry.veil.mixin.rendertype.accessor.RenderTypeAccessor;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class VeilRenderType
extends RenderType {
    public static final RenderStateShard.DepthTestStateShard NEVER_DEPTH_TEST = new RenderStateShard.DepthTestStateShard("never", 512);
    public static final RenderStateShard.DepthTestStateShard LESS_DEPTH_TEST = new RenderStateShard.DepthTestStateShard("<", 513);
    public static final RenderStateShard.DepthTestStateShard NOTEQUAL_DEPTH_TEST = new RenderStateShard.DepthTestStateShard("<", 517);
    public static final RenderStateShard.DepthTestStateShard GEQUAL_DEPTH_TEST = new RenderStateShard.DepthTestStateShard(">=", 518);
    public static final RenderStateShard CULL_FRONT = new CullFaceShard(1028);
    public static final RenderStateShard CULL_BACK = new CullFaceShard(1029);
    public static final RenderStateShard CULL_FRONT_AND_BACK = new CullFaceShard(1032);
    public static final RenderStateShard.WriteMaskStateShard NO_WRITE = new RenderStateShard.WriteMaskStateShard(false, false);
    private static final EnumMap<GlStateManager.LogicOp, RenderStateShard.ColorLogicStateShard> COLOR_LOGIC_SHARDS = new EnumMap(GlStateManager.LogicOp.class);
    private static final RenderStateShard.ShaderStateShard PARTICLE;
    private static final RenderStateShard.ShaderStateShard PARTICLE_ADDITIVE;
    private static final BiFunction<ResourceLocation, Boolean, RenderType> QUASAR_PARTICLE;
    private static final Function<ResourceLocation, RenderType> QUASAR_TRAIL;

    public static RenderType quasarParticle(ResourceLocation texture, boolean additive) {
        return QUASAR_PARTICLE.apply(texture, additive);
    }

    public static RenderType quasarTrail(ResourceLocation texture) {
        return QUASAR_TRAIL.apply(texture);
    }

    public static RenderStateShard.TransparencyStateShard noTransparencyShard() {
        return RenderStateShard.NO_TRANSPARENCY;
    }

    public static RenderStateShard.TransparencyStateShard additiveTransparencyShard() {
        return RenderStateShard.ADDITIVE_TRANSPARENCY;
    }

    public static RenderStateShard.TransparencyStateShard lightningTransparencyShard() {
        return RenderStateShard.LIGHTNING_TRANSPARENCY;
    }

    public static RenderStateShard.TransparencyStateShard glintTransparencyShard() {
        return RenderStateShard.GLINT_TRANSPARENCY;
    }

    public static RenderStateShard.TransparencyStateShard crumblingTransparencyShard() {
        return RenderStateShard.CRUMBLING_TRANSPARENCY;
    }

    public static RenderStateShard.TransparencyStateShard translucentTransparencyShard() {
        return RenderStateShard.TRANSLUCENT_TRANSPARENCY;
    }

    public static RenderStateShard.DepthTestStateShard noDepthTestShard() {
        return RenderStateShard.NO_DEPTH_TEST;
    }

    public static RenderStateShard.DepthTestStateShard equalDepthTestShard() {
        return RenderStateShard.EQUAL_DEPTH_TEST;
    }

    public static RenderStateShard.DepthTestStateShard lequalDepthTestShard() {
        return RenderStateShard.LEQUAL_DEPTH_TEST;
    }

    public static RenderStateShard.DepthTestStateShard greaterDepthTestShard() {
        return RenderStateShard.GREATER_DEPTH_TEST;
    }

    public static RenderStateShard.CullStateShard cullShard() {
        return RenderStateShard.CULL;
    }

    public static RenderStateShard.CullStateShard noCullShard() {
        return RenderStateShard.NO_CULL;
    }

    public static RenderStateShard.LightmapStateShard lightmap() {
        return RenderStateShard.LIGHTMAP;
    }

    public static RenderStateShard.LightmapStateShard noLightmap() {
        return RenderStateShard.NO_LIGHTMAP;
    }

    public static RenderStateShard.OverlayStateShard overlay() {
        return RenderStateShard.OVERLAY;
    }

    public static RenderStateShard.OverlayStateShard noOverlay() {
        return RenderStateShard.NO_OVERLAY;
    }

    public static RenderStateShard.LayeringStateShard noLayering() {
        return RenderStateShard.NO_LAYERING;
    }

    public static RenderStateShard.LayeringStateShard polygonOffsetLayering() {
        return RenderStateShard.POLYGON_OFFSET_LAYERING;
    }

    public static RenderStateShard.LayeringStateShard viewOffsetLayering() {
        return RenderStateShard.VIEW_OFFSET_Z_LAYERING;
    }

    public static RenderStateShard.WriteMaskStateShard colorDepthWriteShard() {
        return RenderStateShard.COLOR_DEPTH_WRITE;
    }

    public static RenderStateShard.WriteMaskStateShard colorWriteShard() {
        return RenderStateShard.COLOR_WRITE;
    }

    public static RenderStateShard.WriteMaskStateShard depthWriteShard() {
        return RenderStateShard.DEPTH_WRITE;
    }

    public static RenderStateShard.ColorLogicStateShard colorLogicStateShard(GlStateManager.LogicOp op) {
        return COLOR_LOGIC_SHARDS.get(op);
    }

    @Nullable
    public static RenderType get(ResourceLocation id, Object ... params) {
        return VeilRenderSystem.renderer().getDynamicRenderTypeManager().get(id, params);
    }

    @Contract(value="_->new", pure=true)
    public static RenderTypeWrapper getWrapper(ResourceLocation id) {
        return new RenderTypeWrapper(id);
    }

    public static String getName(RenderStateShard shard) {
        return ((RenderStateShardAccessor)shard).getName();
    }

    public static VeilRenderTypeAccessor getShards(RenderType renderType) {
        if (!(renderType instanceof RenderType.CompositeRenderType)) {
            throw new IllegalArgumentException("Expected composite render type to be an instance of " + RenderType.CompositeRenderType.class.getName() + ", but was " + String.valueOf(renderType.getClass()));
        }
        RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
        return (VeilRenderTypeAccessor)compositeRenderType.state();
    }

    public static RenderType layered(RenderType ... layers) {
        if (layers.length == 0) {
            throw new IllegalArgumentException("At least 1 render type must be specified");
        }
        if (layers.length == 1) {
            return layers[0];
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        VertexFormat format = layers[0].format();
        VertexFormat.Mode mode = layers[0].mode();
        int bufferSize = layers[0].bufferSize();
        boolean sortOnUpload = ((RenderTypeAccessor)layers[0]).isSortOnUpload();
        for (int i = 1; i < layers.length; ++i) {
            RenderType layer = layers[i];
            if (!layer.format().equals((Object)format)) {
                throw new IllegalArgumentException("Expected " + String.valueOf(layer) + " to use " + String.valueOf(format) + ", but was " + String.valueOf(layer.format()));
            }
            if (!layer.mode().equals((Object)mode)) {
                throw new IllegalArgumentException("Expected " + String.valueOf(layer) + " to use " + String.valueOf(mode) + ", but was " + String.valueOf(layer.mode()));
            }
            bufferSize = Math.max(bufferSize, layer.bufferSize());
            if (((RenderTypeAccessor)layer).isSortOnUpload()) {
                sortOnUpload = true;
            }
            builder.add((Object)layer);
        }
        return new LayeredRenderType(layers[0], (List<RenderType>)builder.build(), "LayeredRenderType[" + Arrays.stream(layers).map(VeilRenderType::getName).collect(Collectors.joining(", ")) + "]", bufferSize, sortOnUpload);
    }

    private VeilRenderType(String $$0, VertexFormat $$1, VertexFormat.Mode $$2, int $$3, boolean $$4, boolean $$5, Runnable $$6, Runnable $$7) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    static {
        for (GlStateManager.LogicOp logicOp : GlStateManager.LogicOp.values()) {
            COLOR_LOGIC_SHARDS.put(logicOp, new RenderStateShard.ColorLogicStateShard(logicOp.name().toLowerCase(Locale.ROOT), () -> {
                RenderSystem.enableColorLogicOp();
                RenderSystem.logicOp((GlStateManager.LogicOp)logicOp);
            }, RenderSystem::disableColorLogicOp));
        }
        PARTICLE = VeilRenderBridge.shaderState(Veil.veilPath("quasar/particle"));
        PARTICLE_ADDITIVE = VeilRenderBridge.shaderState(Veil.veilPath("quasar/particle_additive"));
        QUASAR_PARTICLE = Util.memoize((texture, additive) -> {
            RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(additive != false ? PARTICLE_ADDITIVE : PARTICLE).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(additive != false ? ADDITIVE_TRANSPARENCY : TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setWriteMaskState(COLOR_WRITE).createCompositeState(false);
            return VeilRenderType.create((String)"veil:quasar_particle", (VertexFormat)VeilVertexFormat.QUASAR_PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)false, (additive == false ? 1 : 0) != 0, (RenderType.CompositeState)state);
        });
        QUASAR_TRAIL = Util.memoize(texture -> {
            RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(ADDITIVE_TRANSPARENCY).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).createCompositeState(false);
            return RenderType.create((String)"veil:quasar_trail", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
        });
    }

    public static class RenderTypeWrapper
    extends RenderType {
        private static final Object[] NO_PARAMS = new Object[0];
        private final ResourceLocation id;
        private Object[] params;

        private RenderTypeWrapper(ResourceLocation id) {
            super(id.toString(), DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS, 0, false, false, () -> {}, () -> {});
            this.id = id;
            this.params = NO_PARAMS;
        }

        public void setupRenderState() {
            RenderType renderType = this.get();
            if (renderType != null) {
                renderType.setupRenderState();
            }
        }

        public void clearRenderState() {
            RenderType renderType = this.get();
            if (renderType != null) {
                renderType.clearRenderState();
            }
        }

        public void draw(@NotNull MeshData meshData) {
            RenderType renderType = this.get();
            if (renderType != null) {
                renderType.draw(meshData);
            }
        }

        public int bufferSize() {
            RenderType renderType = this.get();
            return renderType != null ? renderType.bufferSize() : 1536;
        }

        @NotNull
        public VertexFormat format() {
            RenderType renderType = this.get();
            return renderType != null ? renderType.format() : DefaultVertexFormat.POSITION;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull VertexFormat.Mode mode() {
            RenderType renderType = this.get();
            return renderType != null ? renderType.mode() : VertexFormat.Mode.QUADS;
        }

        @NotNull
        public Optional<RenderType> outline() {
            RenderType renderType = this.get();
            return renderType != null ? renderType.outline() : Optional.empty();
        }

        public boolean isOutline() {
            RenderType renderType = this.get();
            return renderType != null && renderType.isOutline();
        }

        public boolean affectsCrumbling() {
            RenderType renderType = this.get();
            return renderType != null && renderType.affectsCrumbling();
        }

        public boolean canConsolidateConsecutiveGeometry() {
            RenderType renderType = this.get();
            return renderType != null && renderType.canConsolidateConsecutiveGeometry();
        }

        public boolean sortOnUpload() {
            RenderType renderType = this.get();
            return renderType != null && renderType.sortOnUpload();
        }

        public void setParams(Object ... params) {
            if (params.length == 0) {
                this.params = NO_PARAMS;
            } else if (this.params.length == params.length) {
                System.arraycopy(params, 0, this.params, 0, params.length);
            } else {
                this.params = Arrays.copyOf(params, params.length);
            }
        }

        @Nullable
        public RenderType get() {
            return VeilRenderSystem.renderer().getDynamicRenderTypeManager().get(this.id, this.params);
        }
    }

    public static class LayeredRenderType
    extends RenderType {
        private final List<RenderType> layers;

        private LayeredRenderType(RenderType defaultValue, List<RenderType> layers, String name, int bufferSize, boolean sortOnUpload) {
            super(name, defaultValue.format(), defaultValue.mode(), bufferSize, defaultValue.affectsCrumbling(), sortOnUpload, () -> ((RenderType)defaultValue).setupRenderState(), () -> ((RenderType)defaultValue).clearRenderState());
            this.layers = layers;
        }

        public void draw(@NotNull MeshData meshData) {
            super.draw(meshData);
            if (BufferUploader.lastImmediateBuffer != null) {
                ShaderInstance shader = RenderSystem.getShader();
                if (shader == null) {
                    return;
                }
                Matrix4f modelViewMatrix = RenderSystem.getModelViewMatrix();
                Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
                for (RenderType layer : this.layers) {
                    layer.setupRenderState();
                    BufferUploader.lastImmediateBuffer.drawWithShader(modelViewMatrix, projectionMatrix, shader);
                    layer.clearRenderState();
                }
            }
        }

        public List<RenderType> getLayers() {
            return this.layers;
        }
    }
}

