/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype.layer;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import foundry.veil.api.client.render.rendertype.layer.RenderTypeLayer;
import foundry.veil.api.client.util.VertexFormatCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.ApiStatus;

public record CompositeRenderTypeData(VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sort, boolean outline, List<RenderTypeLayer[]> layers) {
    private static final Codec<List<List<RenderTypeLayer>>> LAYER_CODEC = Codec.withAlternative((Codec)RenderTypeLayer.CODEC.listOf().listOf().flatXmap(list -> list.size() < 2 ? DataResult.error(() -> "Expected at least 2 layers") : DataResult.success((Object)list), list -> list.size() < 2 ? DataResult.error(() -> "Expected at least 2 layers") : DataResult.success((Object)list)), (Codec)RenderTypeLayer.CODEC.listOf().flatXmap(layers -> DataResult.success(Collections.singletonList(layers)), list -> list.size() == 1 ? DataResult.success((Object)((List)list.getFirst())) : DataResult.error(() -> "Expected 1 shard"))).flatXmap(list -> list.isEmpty() ? DataResult.error(() -> "Expected at least 1 layer") : DataResult.success((Object)list), list -> list.isEmpty() ? DataResult.error(() -> "Expected at least 1 layer") : DataResult.success((Object)list));
    public static final Codec<CompositeRenderTypeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VertexFormatCodec.CODEC.fieldOf("format").forGetter(CompositeRenderTypeData::format), (App)VertexFormatCodec.MODE_CODEC.fieldOf("mode").forGetter(CompositeRenderTypeData::mode), (App)VertexFormatCodec.BUFFER_SIZE_CODEC.fieldOf("bufferSize").forGetter(CompositeRenderTypeData::bufferSize), (App)Codec.BOOL.optionalFieldOf("affectsCrumbling", (Object)false).forGetter(CompositeRenderTypeData::sort), (App)Codec.BOOL.optionalFieldOf("sort", (Object)false).forGetter(CompositeRenderTypeData::sort), (App)Codec.BOOL.optionalFieldOf("outline", (Object)false).forGetter(CompositeRenderTypeData::outline), (App)LAYER_CODEC.fieldOf("layers").forGetter(state -> state.layers().stream().map(Arrays::asList).toList())).apply((Applicative)instance, (format, mode, bufferSize, affectsCrumbling, sort, outline, layersList) -> {
        ArrayList<RenderTypeLayer[]> layers = new ArrayList<RenderTypeLayer[]>(layersList.size());
        for (List shards : layersList) {
            layers.add((RenderTypeLayer[])shards.toArray(RenderTypeLayer[]::new));
        }
        return new CompositeRenderTypeData((VertexFormat)format, (VertexFormat.Mode)mode, (int)bufferSize, (boolean)affectsCrumbling, (boolean)sort, (boolean)outline, Collections.unmodifiableList(layers));
    }));

    @ApiStatus.Internal
    public RenderType createRenderType(String name, Object ... params) {
        RenderType[] renderTypes = new RenderType[this.layers.size()];
        for (int i = 0; i < this.layers.size(); ++i) {
            RenderTypeLayer[] shards = this.layers.get(i);
            VeilRenderTypeBuilder builder = VeilRenderBridge.create(RenderType.CompositeState.builder());
            for (RenderTypeLayer shard : shards) {
                shard.addShard(builder, params);
            }
            RenderType.CompositeState state = builder.create(this.outline);
            renderTypes[i] = RenderType.create((String)name, (VertexFormat)this.format, (VertexFormat.Mode)this.mode, (int)this.bufferSize, (boolean)this.affectsCrumbling, (boolean)this.sort, (RenderType.CompositeState)state);
        }
        return VeilRenderType.layered(renderTypes);
    }
}

