/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.mojang.serialization.Codec;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.util.EnumCodec;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public enum ShaderFeature {
    COMPUTE,
    SHADER_STORAGE,
    ATOMIC_COUNTER,
    BINDLESS_TEXTURE,
    CUBE_MAP_ARRAY;

    @ApiStatus.Internal
    public static final ShaderFeature[] FEATURES;
    public static final Codec<ShaderFeature> CODEC;
    private final String definitionName = "SHADER_FEATURE_" + this.name();

    public boolean isSupported() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> VeilRenderSystem.computeSupported();
            case 1 -> VeilRenderSystem.shaderStorageBufferSupported();
            case 2 -> VeilRenderSystem.atomicCounterSupported();
            case 3 -> VeilRenderSystem.bindlessTextureSupported();
            case 4 -> VeilRenderSystem.textureCubeMapArraySupported();
        };
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public void modifyShader(GlslTree tree) {
        List directives = tree.getDirectives();
        switch (this.ordinal()) {
            case 0: {
                directives.add("#extension GL_ARB_compute_shader : require");
                break;
            }
            case 1: {
                directives.add("#extension GL_ARB_shader_storage_buffer_object : require");
                break;
            }
            case 2: {
                directives.add("#extension GL_ARB_shader_atomic_counters : require");
                break;
            }
            case 3: {
                directives.add("#extension GL_NV_gpu_shader5 : enable");
                directives.add("#extension GL_EXT_nonuniform_qualifier : enable");
            }
        }
    }

    static {
        FEATURES = ShaderFeature.values();
        CODEC = EnumCodec.builder("Shader Feature").values(ShaderFeature.values()).build();
    }
}

