/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.mixin.pipeline.accessor.PipelineNativeImageAccessor;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL12C;

public abstract class ArrayTexture
extends AbstractTexture {
    private int width;
    private int height;

    protected void init(int format, int mipmapLevel, int width, int height, int depth) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.bind();
        if (mipmapLevel >= 0) {
            GlStateManager._texParameter((int)35866, (int)33085, (int)mipmapLevel);
            GlStateManager._texParameter((int)35866, (int)33082, (int)0);
            GlStateManager._texParameter((int)35866, (int)33083, (int)mipmapLevel);
            GlStateManager._texParameter((int)35866, (int)34049, (float)0.0f);
        }
        this.width = width;
        this.height = height;
        for (int i = 0; i <= mipmapLevel; ++i) {
            GL12C.glTexImage3D((int)35866, (int)i, (int)format, (int)(width >> i), (int)(height >> i), (int)depth, (int)0, (int)6408, (int)5121, (long)0L);
        }
    }

    protected void upload(NativeImage ... images) {
        this.bind();
        for (int i = 0; i < images.length; ++i) {
            NativeImage image = images[i];
            if (image.getWidth() != this.width || image.getHeight() != this.height) {
                throw new IllegalArgumentException("Image dimensions don't match");
            }
            GL12C.glTexSubImage3D((int)35866, (int)0, (int)0, (int)0, (int)i, (int)image.getWidth(), (int)image.getHeight(), (int)1, (int)image.format().glFormat(), (int)5121, (long)((PipelineNativeImageAccessor)image).getPixels());
        }
    }

    public void setFilter(boolean blur, boolean mipmap) {
        int magFilter;
        int minFilter;
        RenderSystem.assertOnRenderThreadOrInit();
        this.blur = blur;
        this.mipmap = mipmap;
        if (blur) {
            minFilter = mipmap ? 9987 : 9729;
            magFilter = 9729;
        } else {
            minFilter = mipmap ? 9986 : 9728;
            magFilter = 9728;
        }
        if (VeilRenderSystem.directStateAccessSupported()) {
            int id = this.getId();
            ARBDirectStateAccess.glTextureParameteri((int)id, (int)10241, (int)minFilter);
            ARBDirectStateAccess.glTextureParameteri((int)id, (int)10240, (int)magFilter);
        } else {
            this.bind();
            GL12C.glTexParameteri((int)35866, (int)10241, (int)minFilter);
            GL12C.glTexParameteri((int)35866, (int)10240, (int)magFilter);
        }
    }

    public int getId() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.id == -1) {
            this.id = VeilRenderSystem.createTextures(35866);
        }
        return this.id;
    }

    public void bind() {
        GL12C.glBindTexture((int)35866, (int)this.getId());
    }
}

