/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.Direction;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL13C;

public abstract class CubemapTexture
extends AbstractTexture {
    public static int getGlFace(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> 34072;
            case Direction.UP -> 34071;
            case Direction.NORTH -> 34074;
            case Direction.SOUTH -> 34073;
            case Direction.WEST -> 34070;
            case Direction.EAST -> 34069;
        };
    }

    public void setFilter(boolean blur, boolean mipmap) {
        int magFilter;
        int minFilter;
        RenderSystem.assertOnRenderThreadOrInit();
        this.blur = blur;
        this.mipmap = mipmap;
        if (blur) {
            minFilter = mipmap ? 9987 : 9729;
            magFilter = 9729;
        } else {
            minFilter = mipmap ? 9986 : 9728;
            magFilter = 9728;
        }
        if (VeilRenderSystem.directStateAccessSupported()) {
            int id = this.getId();
            ARBDirectStateAccess.glTextureParameteri((int)id, (int)10241, (int)minFilter);
            ARBDirectStateAccess.glTextureParameteri((int)id, (int)10240, (int)magFilter);
        } else {
            this.bind();
            GL13C.glTexParameteri((int)34067, (int)10241, (int)minFilter);
            GL13C.glTexParameteri((int)34067, (int)10240, (int)magFilter);
        }
    }

    public int getId() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.id == -1) {
            this.id = VeilRenderSystem.createTextures(34067);
        }
        return this.id;
    }

    public void bind() {
        VeilRenderSystem.renderThreadExecutor().execute(() -> GL13C.glBindTexture((int)34067, (int)this.getId()));
    }
}

