/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import foundry.veil.api.client.render.texture.CubemapTexture;
import foundry.veil.api.client.render.texture.VeilPreloadedTexture;
import foundry.veil.mixin.pipeline.accessor.PipelineNativeImageAccessor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL12C;
import org.slf4j.Logger;

public class SimpleCubemapTexture
extends CubemapTexture
implements VeilPreloadedTexture {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final ResourceLocation location;
    private CompletableFuture<TextureImage> imageFuture;

    public SimpleCubemapTexture(ResourceLocation location) {
        this.location = location;
        this.imageFuture = null;
    }

    @Override
    public CompletableFuture<?> preload(ResourceManager resourceManager, Executor backgroundExecutor) {
        if (this.imageFuture == null || this.imageFuture.isDone()) {
            this.imageFuture = CompletableFuture.supplyAsync(() -> TextureImage.load(resourceManager, this.location), backgroundExecutor);
        }
        return this.imageFuture;
    }

    public void load(@NotNull ResourceManager resourceManager) throws IOException {
        TextureImage textureImages = this.getTextureImage(resourceManager);
        try (NativeImage image = textureImages.getImage();){
            boolean clamp;
            boolean blur;
            int width = image.getWidth();
            int height = image.getHeight();
            if (height != width * 3 / 4) {
                throw new IOException("Expected cubemap image to be " + width + "x" + width * 3 / 4 + ". Was " + width + "x" + height);
            }
            TextureMetadataSection texturemetadatasection = textureImages.getTextureMetadata();
            if (texturemetadatasection != null) {
                blur = texturemetadatasection.isBlur();
                clamp = texturemetadatasection.isClamp();
            } else {
                blur = false;
                clamp = false;
            }
            this.setFilter(blur, clamp);
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                RenderSystem.recordRenderCall(() -> this.loadImages(image));
            } else {
                this.loadImages(image);
            }
        }
    }

    private void loadImages(NativeImage image) {
        try (NativeImage nativeImage = image;){
            this.bind();
            GlStateManager._texParameter((int)34067, (int)33085, (int)0);
            GlStateManager._texParameter((int)34067, (int)33082, (int)0);
            GlStateManager._texParameter((int)34067, (int)33083, (int)0);
            GlStateManager._texParameter((int)34067, (int)34049, (float)0.0f);
            int tileSize = image.getWidth() / 4;
            PipelineNativeImageAccessor accessor = (PipelineNativeImageAccessor)image;
            accessor.invokeCheckAllocated();
            NativeImage.Format format = image.format();
            format.setUnpackPixelStoreState();
            long pixels = accessor.getPixels();
            GlStateManager._pixelStore((int)3314, (int)image.getWidth());
            GlStateManager._pixelStore((int)3316, (int)tileSize);
            GlStateManager._pixelStore((int)3315, (int)0);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(Direction.UP), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.glFormat(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)0);
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(Direction.WEST), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.glFormat(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)tileSize);
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(Direction.SOUTH), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.glFormat(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)(tileSize * 2));
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(Direction.EAST), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.glFormat(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)(tileSize * 3));
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(Direction.NORTH), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.glFormat(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)tileSize);
            GlStateManager._pixelStore((int)3315, (int)(tileSize * 2));
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(Direction.DOWN), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.glFormat(), (int)5121, (long)pixels);
        }
    }

    public void reset(@NotNull TextureManager textureManager, @NotNull ResourceManager resourceManager, @NotNull ResourceLocation location, @NotNull Executor gameExecutor) {
        this.preload(resourceManager, Util.backgroundExecutor()).thenRunAsync(() -> textureManager.register(location, (AbstractTexture)this), gameExecutor);
    }

    protected TextureImage getTextureImage(ResourceManager resourceManager) {
        if (this.imageFuture != null) {
            TextureImage image = this.imageFuture.join();
            this.imageFuture = null;
            return image;
        }
        return TextureImage.load(resourceManager, this.location);
    }

    protected static class TextureImage
    implements Closeable {
        @Nullable
        private final TextureMetadataSection metadata;
        @Nullable
        private final NativeImage image;
        @Nullable
        private final IOException exception;

        public TextureImage(IOException exception) {
            this.exception = exception;
            this.metadata = null;
            this.image = null;
        }

        public TextureImage(@Nullable TextureMetadataSection metadata, NativeImage image) {
            this.exception = null;
            this.metadata = metadata;
            this.image = image;
        }

        public static TextureImage load(ResourceManager resourceManager, ResourceLocation location) {
            try {
                NativeImage nativeimage;
                Resource resource = resourceManager.getResourceOrThrow(location);
                try (InputStream inputstream = resource.open();){
                    nativeimage = NativeImage.read((InputStream)inputstream);
                }
                TextureMetadataSection texturemetadatasection = null;
                try {
                    texturemetadatasection = resource.metadata().getSection((MetadataSectionSerializer)TextureMetadataSection.SERIALIZER).orElse(null);
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.warn("Failed reading metadata of: {}", (Object)location, (Object)runtimeexception);
                }
                return new TextureImage(texturemetadatasection, nativeimage);
            }
            catch (IOException ioexception) {
                return new TextureImage(ioexception);
            }
        }

        @Nullable
        public TextureMetadataSection getTextureMetadata() {
            return this.metadata;
        }

        public NativeImage getImage() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.image;
        }

        @Override
        public void close() {
            if (this.image != null) {
                this.image.close();
            }
        }

        public void throwIfError() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

