/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public record TextureTypeMetadataSection(TextureType type) {
    public static final Serializer SERIALIZER = new Serializer();

    public static enum TextureType {
        TEXTURE_2D,
        TEXTURE_2D_ARRAY,
        TEXTURE_CUBE_MAP;

        private static final TextureType[] VALUES;

        static {
            VALUES = TextureType.values();
        }
    }

    public static class Serializer
    implements MetadataSectionSerializer<TextureTypeMetadataSection> {
        public TextureTypeMetadataSection fromJson(@NotNull JsonObject json) {
            String type = GsonHelper.getAsString((JsonObject)json, (String)"type", (String)"2d");
            for (TextureType value : TextureType.VALUES) {
                if (!value.name().substring(8).equalsIgnoreCase(type)) continue;
                return new TextureTypeMetadataSection(value);
            }
            throw new JsonSyntaxException("Unknown texture type: " + type + ". Expected one of " + Arrays.stream(TextureType.VALUES).map(textureType -> textureType.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", ")));
        }

        @NotNull
        public String getMetadataSectionName() {
            return "veil:texture_type";
        }
    }
}

