/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class ScissorStack {
    private final Deque<ScreenRectangle> regions = new ArrayDeque<ScreenRectangle>();

    private void apply(ScreenRectangle rectangle) {
        RenderSystem.enableScissor((int)rectangle.left(), (int)(Minecraft.getInstance().getWindow().getHeight() - rectangle.bottom()), (int)rectangle.width(), (int)rectangle.height());
    }

    public void push(int x, int y, int width, int height) {
        this.push((float)x, (float)y, (float)width, (float)height);
    }

    public void push(float x, float y, float width, float height) {
        if (!this.regions.isEmpty()) {
            float scale = (float)Minecraft.getInstance().getWindow().getGuiScale();
            float x2 = x + width;
            float y2 = y + height;
            ScreenRectangle parent = this.regions.peek();
            x = Mth.clamp((float)(x * scale), (float)parent.left(), (float)parent.right());
            width = Mth.clamp((float)(x2 * scale), (float)parent.left(), (float)parent.right()) - x;
            y = Mth.clamp((float)(y * scale), (float)parent.top(), (float)parent.bottom());
            height = Mth.clamp((float)(y2 * scale), (float)parent.top(), (float)parent.bottom()) - y;
        }
        ScreenRectangle region = new ScreenRectangle((int)x, (int)y, (int)width, (int)height);
        this.regions.push(region);
        this.apply(region);
    }

    public void pop() {
        this.regions.pop();
        if (this.regions.isEmpty()) {
            RenderSystem.disableScissor();
        } else {
            this.apply(this.regions.peek());
        }
    }

    @Nullable
    public ScreenRectangle getTop() {
        return this.regions.isEmpty() ? null : this.regions.peek();
    }

    public boolean containsPoint(float x, float y) {
        if (this.regions.isEmpty()) {
            return true;
        }
        float scale = (float)Minecraft.getInstance().getWindow().getGuiScale();
        return this.regions.peek().containsPoint((int)(x * scale), (int)(y * scale));
    }

    public int size() {
        return this.regions.size();
    }

    public boolean isEmpty() {
        return this.regions.isEmpty();
    }

    public void clear() {
        this.regions.clear();
        RenderSystem.disableScissor();
    }
}

