/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.event;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.client.render.MatrixStack;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import org.joml.Matrix4fc;

@FunctionalInterface
public interface VeilRenderLevelStageEvent {
    public void onRenderLevelStage(Stage var1, LevelRenderer var2, MultiBufferSource.BufferSource var3, MatrixStack var4, Matrix4fc var5, Matrix4fc var6, int var7, DeltaTracker var8, Camera var9, Frustum var10);

    public static enum Stage {
        AFTER_SKY,
        AFTER_SOLID_BLOCKS,
        AFTER_CUTOUT_MIPPED_BLOCKS,
        AFTER_CUTOUT_BLOCKS,
        AFTER_ENTITIES,
        AFTER_BLOCK_ENTITIES,
        AFTER_TRANSLUCENT_BLOCKS,
        AFTER_TRIPWIRE_BLOCKS,
        AFTER_PARTICLES,
        AFTER_WEATHER,
        AFTER_LEVEL;

        private static final Stage[] VALUES;
        public static final Codec<Stage> CODEC;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String getName() {
            return this.name;
        }

        static {
            VALUES = Stage.values();
            CODEC = Codec.STRING.flatXmap(name -> {
                for (Stage stage : VALUES) {
                    if (!stage.getName().equals(name)) continue;
                    return DataResult.success((Object)((Object)stage));
                }
                return DataResult.error(() -> "Unknown render stage: " + name + ". Valid stages: " + Arrays.stream(VALUES).map(Stage::getName).collect(Collectors.joining(", ")));
            }, stage -> DataResult.success((Object)stage.getName()));
        }
    }
}

