/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource;

import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import imgui.ImGui;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;

public interface VeilResource<T extends VeilResource<?>> {
    default public void render(boolean dragging, boolean fullName) {
        VeilImGuiUtil.icon(this.getIconCode());
        ImGui.sameLine();
        VeilResourceInfo resourceInfo = this.resourceInfo();
        ImGui.pushStyleColor((int)0, (int)(resourceInfo.isStatic() ? -5592406 : -1));
        if (dragging || fullName) {
            VeilImGuiUtil.resourceLocation(resourceInfo.location());
        } else {
            ImGui.text((String)resourceInfo.fileName());
        }
        ImGui.popStyleColor();
    }

    default public CompletableFuture<?> onFileSystemChange(VeilResourceManager resourceManager, WatchEvent<Path> event) {
        if (this.canHotReload() && (event.kind() == StandardWatchEventKinds.ENTRY_CREATE || event.kind() == StandardWatchEventKinds.ENTRY_MODIFY)) {
            Veil.LOGGER.info("Hot swapping {} after file system change", (Object)this.resourceInfo().location());
            return ((CompletableFuture)CompletableFuture.runAsync(() -> {
                try {
                    this.copyToResources();
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, task -> Minecraft.getInstance().tell(() -> Util.ioPool().execute(task))).thenRunAsync(() -> {
                try {
                    this.hotReload(resourceManager);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, (Executor)Minecraft.getInstance())).exceptionally(e -> {
                while (e instanceof CompletionException) {
                    e = e.getCause();
                }
                Veil.LOGGER.error("Failed to hot swap file system change", e);
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    public VeilResourceInfo resourceInfo();

    public List<VeilResourceAction<T>> getActions();

    public boolean canHotReload();

    public void hotReload(VeilResourceManager var1) throws IOException;

    default public void copyToResources() throws IOException {
        VeilResourceInfo info = this.resourceInfo();
        Path filePath = info.filePath();
        if (filePath == null) {
            return;
        }
        Path modPath = info.modResourcePath();
        if (modPath == null) {
            return;
        }
        try (InputStream is = Files.newInputStream(modPath, new OpenOption[0]);
             OutputStream os = Files.newOutputStream(filePath, StandardOpenOption.TRUNCATE_EXISTING);){
            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
        }
    }

    public int getIconCode();
}

