/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource;

import foundry.veil.VeilClient;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.type.McMetaResource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jetbrains.annotations.Nullable;

public interface VeilResourceManager {
    public static VeilResourceManager get() {
        return VeilClient.resourceManager();
    }

    default public ResourceManager resources(VeilResourceInfo resourceInfo) {
        return resourceInfo.packType() == PackType.SERVER_DATA ? this.serverResources() : this.clientResources();
    }

    public ResourceManager clientResources();

    public ResourceManager serverResources();

    @Nullable
    public VeilResource<?> getVeilResource(String var1, String var2);

    @Nullable
    default public VeilResource<?> getVeilResource(ResourceLocation location) {
        return this.getVeilResource(location.getNamespace(), location.getPath());
    }

    @Nullable
    default public ResourceMetadata getResourceMetadata(String namespace, String path) {
        ResourceMetadata resourceMetadata;
        VeilResource<?> resource = this.getVeilResource(namespace, path);
        if (resource instanceof McMetaResource) {
            McMetaResource mcMetaResource = (McMetaResource)resource;
            resourceMetadata = mcMetaResource.metadata();
        } else {
            resourceMetadata = null;
        }
        return resourceMetadata;
    }

    @Nullable
    default public ResourceMetadata getResourceMetadata(ResourceLocation location) {
        return this.getResourceMetadata(location.getNamespace(), location.getPath());
    }
}

