/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.resource.type.BlockModelResource;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

@ApiStatus.Internal
public class BlockModelInspector
implements ResourceFileEditor<BlockModelResource> {
    private static final Component TITLE = Component.translatable((String)"inspector.veil.block_model.title");
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private static final PoseStack.Pose POSE = new PoseStack().last();
    private final ImBoolean open = new ImBoolean(true);
    private final VeilResourceManager resourceManager;
    private final BlockModelResource resource;
    private ObjectArrayList<BakedQuad> quads;

    public BlockModelInspector(VeilEditorEnvironment environment, BlockModelResource resource) {
        this.resourceManager = environment.getResourceManager();
        this.resource = resource;
        this.loadFromDisk();
    }

    @Override
    public void render() {
        if (this.resource == null || !this.open.get()) {
            return;
        }
        VeilResourceInfo resourceInfo = this.resource.resourceInfo();
        ImGui.setNextWindowSizeConstraints((float)256.0f, (float)256.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        ImGui.setNextWindowSize((float)256.0f, (float)256.0f, (int)2);
        if (ImGui.begin((String)(TITLE.getString() + "###model_editor_" + resourceInfo.fileName()), (ImBoolean)this.open, (int)264)) {
            VeilImGuiUtil.resourceLocation(resourceInfo.location());
            int desiredWidth = ((int)ImGui.getContentRegionAvailX() - 2) * 2;
            int desiredHeight = ((int)ImGui.getContentRegionAvailY() - 2) * 2;
            if (desiredWidth <= 0 || desiredHeight <= 0) {
                ImGui.end();
                return;
            }
            int texture = VeilImGuiUtil.renderArea(desiredWidth, desiredHeight, fbo -> {
                double time = ImGui.getTime();
                double yaw = Math.toRadians(time * 45.0);
                double pitch = Math.toRadians(30.0);
                Quaterniond cameraOrientation = new Quaterniond().rotateX(pitch).rotateY(yaw);
                Vector3d cameraPos = cameraOrientation.transformInverse(new Vector3d(0.0, 0.0, 2.8)).add(0.5, 0.5, 0.5);
                Matrix4f viewMatrix = new Matrix4f().rotate((Quaternionfc)new Quaternionf((Quaterniondc)cameraOrientation)).translate((float)(-cameraPos.x), (float)(-cameraPos.y), (float)(-cameraPos.z));
                float aspect = (float)desiredWidth / (float)desiredHeight;
                Matrix4f projMat = new Matrix4f().perspective((float)Math.toRadians(40.0), aspect, 0.3f, 1000.0f);
                Matrix4f modelView = new Matrix4f().mul((Matrix4fc)viewMatrix);
                BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                for (BakedQuad quad : this.quads) {
                    builder.putBulkData(POSE, quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
                }
                MeshData data = builder.build();
                if (data != null) {
                    RenderType renderType = RenderType.translucent();
                    Matrix4fStack stack = RenderSystem.getModelViewStack();
                    stack.pushMatrix();
                    stack.set((Matrix4fc)modelView);
                    RenderSystem.applyModelViewMatrix();
                    RenderSystem.backupProjectionMatrix();
                    RenderSystem.setProjectionMatrix((Matrix4f)projMat, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
                    renderType.draw(data);
                    stack.popMatrix();
                    RenderSystem.restoreProjectionMatrix();
                    RenderSystem.applyModelViewMatrix();
                    renderType.clearRenderState();
                }
            });
            if (ImGui.beginChild((String)"3D View", (float)((float)desiredWidth / 2.0f + 2.0f), (float)((float)desiredHeight / 2.0f + 2.0f), (boolean)false, (int)8)) {
                ImGui.image((long)texture, (float)((float)desiredWidth / 2.0f), (float)((float)desiredHeight / 2.0f), (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            }
            ImGui.endChild();
        }
        ImGui.end();
    }

    @Override
    public boolean isClosed() {
        return !this.open.get();
    }

    @Override
    public BlockModelResource getResource() {
        return this.resource;
    }

    @Override
    public void loadFromDisk() {
        Minecraft client = Minecraft.getInstance();
        this.quads = new ObjectArrayList();
        try (BufferedReader reader = this.resource.resourceInfo().openAsReader(this.resourceManager);){
            BlockModel unbaked = BlockModel.fromStream((Reader)reader);
            unbaked.resolveParents(location -> {
                BlockModel blockModel;
                block8: {
                    BufferedReader parentReader = client.getResourceManager().openAsReader(ModelBakery.MODEL_LISTER.idToFile(location));
                    try {
                        blockModel = BlockModel.fromStream((Reader)parentReader);
                        if (parentReader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parentReader != null) {
                                try {
                                    ((Reader)parentReader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            Veil.LOGGER.error("Failed to load block model", (Throwable)e);
                            return BlockModel.fromString((String)ModelBakery.MISSING_MODEL_MESH);
                        }
                    }
                    ((Reader)parentReader).close();
                }
                return blockModel;
            });
            List elements = unbaked.getElements();
            for (BlockElement blockelement : elements) {
                for (Direction direction : blockelement.faces.keySet()) {
                    BlockElementFace blockelementface = (BlockElementFace)blockelement.faces.get(direction);
                    Material material = unbaked.getMaterial(blockelementface.texture());
                    TextureAtlasSprite sprite = (TextureAtlasSprite)client.getTextureAtlas(material.atlasLocation()).apply(material.texture());
                    this.quads.add((Object)FACE_BAKERY.bakeQuad(blockelement.from, blockelement.to, blockelementface, sprite, direction, (ModelState)BlockModelRotation.X0_Y0, blockelement.rotation, blockelement.shade));
                }
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to load block model", (Throwable)e);
        }
    }
}

