/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import foundry.veil.Veil;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public interface ResourceFileEditor<T extends VeilResource<?>>
extends Closeable {
    public void render();

    public void loadFromDisk();

    public boolean isClosed();

    public T getResource();

    @Override
    default public void close() {
    }

    default public CompletableFuture<?> save(JsonElement element, VeilResourceManager resourceManager, VeilResource<?> resource) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setLenient(true);
        jsonWriter.setIndent("  ");
        Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
        return this.save(stringWriter.toString().getBytes(StandardCharsets.UTF_8), resourceManager, resource);
    }

    default public CompletableFuture<?> save(byte[] data, VeilResourceManager resourceManager, VeilResource<?> resource) {
        VeilResourceInfo info = resource.resourceInfo();
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                if (info.isStatic()) {
                    throw new IOException("Read-only resource");
                }
                Path path = info.filePath();
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    os.write(data);
                }
                Path modPath = info.modResourcePath();
                if (modPath == null) {
                    return;
                }
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
                     OutputStream os = Files.newOutputStream(modPath, StandardOpenOption.TRUNCATE_EXISTING);){
                    IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to write resource: {}", (Object)info.location(), (Object)e);
            }
        }, Util.ioPool()).thenRunAsync(() -> {
            try {
                resource.hotReload(resourceManager);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }, (Executor)Minecraft.getInstance())).exceptionally(e -> {
            while (e instanceof CompletionException) {
                e = e.getCause();
            }
            Veil.LOGGER.error("Failed to hot-swap resource: {}", (Object)info.location(), e);
            return null;
        });
    }

    @FunctionalInterface
    public static interface Factory<T extends VeilResource<?>> {
        @Nullable
        public ResourceFileEditor<T> open(VeilEditorEnvironment var1, T var2);
    }
}

