/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeReloadListener
implements PreparableReloadListener {
    private final PreparableReloadListener[] listeners;

    private CompositeReloadListener(PreparableReloadListener[] listeners) {
        this.listeners = listeners;
    }

    public static PreparableReloadListener of(PreparableReloadListener ... listeners) {
        if (listeners.length == 0) {
            return new PreparableReloadListener(){

                @NotNull
                public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller prepareProfiler, @NotNull ProfilerFiller applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
                    return preparationBarrier.wait(null);
                }

                @NotNull
                public String getName() {
                    return "EmptyListener";
                }
            };
        }
        if (listeners.length == 1) {
            return listeners[0];
        }
        return new CompositeReloadListener(listeners);
    }

    @NotNull
    public CompletableFuture<Void> reload(final @NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller prepareProfiler, @NotNull ProfilerFiller applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        final CompletableFuture allComplete = new CompletableFuture();
        final HashSet<PreparableReloadListener> preparingListeners = new HashSet<PreparableReloadListener>(Arrays.asList(this.listeners));
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.listeners.length);
        for (final PreparableReloadListener listener : this.listeners) {
            PreparableReloadListener.PreparationBarrier barrier = new PreparableReloadListener.PreparationBarrier(){

                @NotNull
                public <T> CompletableFuture<T> wait(@Nullable T backgroundResult) {
                    if (preparingListeners.remove(listener) && preparingListeners.isEmpty()) {
                        preparationBarrier.wait(null).thenRun(() -> allComplete.complete(Unit.INSTANCE));
                    }
                    return allComplete.thenApply(unused -> backgroundResult);
                }
            };
            futures.add(listener.reload(barrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String getName() {
        return "CompositeListener[" + Arrays.stream(this.listeners).map(PreparableReloadListener::getName).collect(Collectors.joining(",")) + "]";
    }
}

